/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.model;

import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.tfs.model.GitStatusContext;
import hudson.plugins.tfs.model.GitStatusState;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;

public class TeamGitStatus {
    private static final Map<Result, GitStatusState> RESULT_TO_STATE;
    public GitStatusState state;
    public String description;
    public String targetUrl;
    public GitStatusContext context;

    public static TeamGitStatus fromRun(@Nonnull Run<?, ?> run) {
        TeamGitStatus status = new TeamGitStatus();
        Result result = run.getResult();
        if (result == null) {
            status.state = GitStatusState.Pending;
            status.description = status.state.toString();
        } else {
            status.state = RESULT_TO_STATE.get(result);
            status.description = result.toString();
        }
        Job job = run.getParent();
        status.description = job.getDisplayName() + run.getDisplayName() + ": " + status.description;
        status.targetUrl = run.getAbsoluteUrl();
        status.context = TeamGitStatus.getStatusContext(job);
        return status;
    }

    public static TeamGitStatus fromJob(@Nonnull Job job) {
        TeamGitStatus status = new TeamGitStatus();
        status.state = GitStatusState.Pending;
        status.description = "Jenkins Job " + job.getDisplayName() + " queued";
        status.targetUrl = job.getAbsoluteUrl();
        status.context = TeamGitStatus.getStatusContext(job);
        return status;
    }

    private static GitStatusContext getStatusContext(@Nonnull Job job) {
        String instanceUrl = StringUtils.stripEnd((String)Jenkins.getInstance().getRootUrl(), (String)"/");
        String projectDisplayName = job.getParent().getFullName() + "/" + job.getDisplayName();
        return new GitStatusContext(projectDisplayName, instanceUrl);
    }

    public String toJson() {
        JSONObject jsonObject = JSONObject.fromObject((Object)this);
        String result = jsonObject.toString();
        return result;
    }

    static {
        HashMap<Result, GitStatusState> resultToStatus = new HashMap<Result, GitStatusState>();
        resultToStatus.put(Result.SUCCESS, GitStatusState.Succeeded);
        resultToStatus.put(Result.UNSTABLE, GitStatusState.Failed);
        resultToStatus.put(Result.FAILURE, GitStatusState.Failed);
        resultToStatus.put(Result.NOT_BUILT, GitStatusState.Error);
        resultToStatus.put(Result.ABORTED, GitStatusState.Error);
        RESULT_TO_STATE = Collections.unmodifiableMap(resultToStatus);
    }
}

