/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.model;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.microsoft.tfs.core.TFSConfigurationServer;
import com.microsoft.tfs.core.TFSConnection;
import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.webservices.IIdentityManagementService;
import com.microsoft.tfs.core.clients.webservices.IdentityManagementException;
import com.microsoft.tfs.core.clients.webservices.IdentityManagementService;
import com.microsoft.tfs.core.config.ConnectionAdvisor;
import com.microsoft.tfs.core.config.persistence.DefaultPersistenceStoreProvider;
import com.microsoft.tfs.core.config.persistence.PersistenceStoreProvider;
import com.microsoft.tfs.core.httpclient.Credentials;
import com.microsoft.tfs.core.httpclient.DefaultNTCredentials;
import com.microsoft.tfs.core.httpclient.HttpClient;
import com.microsoft.tfs.core.httpclient.UsernamePasswordCredentials;
import com.microsoft.tfs.core.util.CredentialsUtils;
import com.microsoft.tfs.core.util.URIUtils;
import com.microsoft.tfs.jni.helpers.LocalHost;
import com.microsoft.tfs.util.Closable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Launcher;
import hudson.ProxyConfiguration;
import hudson.model.TaskListener;
import hudson.plugins.tfs.TeamPluginGlobalConfig;
import hudson.plugins.tfs.commands.ServerConfigurationProvider;
import hudson.plugins.tfs.model.ClonePersistenceStoreProvider;
import hudson.plugins.tfs.model.ExtraSettings;
import hudson.plugins.tfs.model.LegacyIdentityManagementService;
import hudson.plugins.tfs.model.MockableVersionControlClient;
import hudson.plugins.tfs.model.ModernConnectionAdvisor;
import hudson.plugins.tfs.model.NativeLibraryManager;
import hudson.plugins.tfs.model.Project;
import hudson.plugins.tfs.model.ProxyHostEx;
import hudson.plugins.tfs.model.WebProxySettings;
import hudson.plugins.tfs.model.Workspaces;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.util.Secret;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;

public class Server
implements ServerConfigurationProvider,
Closable {
    private static final Logger LOGGER = Logger.getLogger(Server.class.getName());
    private final String url;
    private final String userName;
    private final String userPassword;
    private Workspaces workspaces;
    private Map<String, Project> projects = new HashMap<String, Project>();
    private final Launcher launcher;
    private final TaskListener taskListener;
    private final TFSTeamProjectCollection tpc;
    private final WebProxySettings webProxySettings;
    private final ExtraSettings extraSettings;
    private MockableVersionControlClient mockableVcc;
    private static HashMap<String, PersistenceStoreProvider> persistenceStoreProviderCache = new HashMap();

    public Server(Launcher launcher, TaskListener taskListener, String url, String username, String password) throws IOException {
        this(launcher, taskListener, url, username, password, null, null);
    }

    public static Server create(Launcher launcher, TaskListener taskListener, String url, StandardUsernamePasswordCredentials credentials, WebProxySettings webProxySettings, ExtraSettings extraSettings) throws IOException {
        String userPassword;
        String username;
        if (credentials == null) {
            username = null;
            userPassword = null;
        } else {
            username = credentials.getUsername();
            Secret password = credentials.getPassword();
            userPassword = password.getPlainText();
        }
        return new Server(launcher, taskListener, url, username, userPassword, webProxySettings, extraSettings);
    }

    public Server(Launcher launcher, TaskListener taskListener, String url, String username, String password, WebProxySettings webProxySettings, ExtraSettings extraSettings) throws IOException {
        this.launcher = launcher;
        this.taskListener = taskListener;
        this.url = url;
        this.userName = username;
        this.userPassword = password;
        URI uri = URIUtils.newURI((String)url);
        NativeLibraryManager.initialize();
        DefaultNTCredentials credentials = null;
        if ((username == null || username.length() == 0) && CredentialsUtils.supportsDefaultCredentials()) {
            credentials = new DefaultNTCredentials();
        } else if (username != null && password != null) {
            credentials = new UsernamePasswordCredentials(username, password);
        }
        if (credentials != null) {
            Object provider;
            VirtualChannel channel;
            VirtualChannel virtualChannel = channel = launcher != null ? launcher.getChannel() : null;
            if (webProxySettings != null) {
                this.webProxySettings = webProxySettings;
            } else {
                ProxyConfiguration proxyConfiguration = Server.determineProxyConfiguration(channel);
                this.webProxySettings = new WebProxySettings(proxyConfiguration);
            }
            String host = uri.getHost();
            ProxyHostEx proxyHost = this.webProxySettings.toProxyHost(host);
            if (extraSettings != null) {
                this.extraSettings = extraSettings;
            } else {
                TeamPluginGlobalConfig globalConfig = Server.determineGlobalConfig(channel);
                this.extraSettings = new ExtraSettings(globalConfig);
            }
            DefaultPersistenceStoreProvider defaultProvider = DefaultPersistenceStoreProvider.INSTANCE;
            if (this.extraSettings.isConfigFolderPerNode()) {
                String hostName = LocalHost.getShortName();
                if (persistenceStoreProviderCache.containsKey(hostName)) {
                    provider = persistenceStoreProviderCache.get(hostName);
                } else {
                    provider = new ClonePersistenceStoreProvider((PersistenceStoreProvider)defaultProvider, hostName);
                    persistenceStoreProviderCache.put(hostName, (PersistenceStoreProvider)provider);
                }
            } else {
                provider = defaultProvider;
            }
            ModernConnectionAdvisor advisor = new ModernConnectionAdvisor(proxyHost, (PersistenceStoreProvider)provider);
            this.tpc = new TFSTeamProjectCollection(uri, (Credentials)credentials, (ConnectionAdvisor)advisor);
        } else {
            this.webProxySettings = null;
            this.extraSettings = null;
            this.tpc = null;
        }
    }

    static TeamPluginGlobalConfig determineGlobalConfig(VirtualChannel channel) {
        TeamPluginGlobalConfig result;
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            if (channel != null) {
                try {
                    result = (TeamPluginGlobalConfig)((Object)channel.call((Callable)new MasterToSlaveCallable<TeamPluginGlobalConfig, Throwable>(){

                        public TeamPluginGlobalConfig call() throws Throwable {
                            Jenkins jenkins = Jenkins.getInstance();
                            TeamPluginGlobalConfig result = jenkins != null ? TeamPluginGlobalConfig.get() : null;
                            return result;
                        }
                    }));
                }
                catch (Throwable throwable) {
                    throw new Error(throwable);
                }
            } else {
                result = TeamPluginGlobalConfig.DEFAULT_CONFIG;
            }
        } else {
            result = TeamPluginGlobalConfig.get();
        }
        return result;
    }

    static ProxyConfiguration determineProxyConfiguration(VirtualChannel channel) {
        ProxyConfiguration proxyConfiguration;
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            if (channel != null) {
                try {
                    proxyConfiguration = (ProxyConfiguration)channel.call((Callable)new MasterToSlaveCallable<ProxyConfiguration, Throwable>(){

                        public ProxyConfiguration call() throws Throwable {
                            Jenkins jenkins = Jenkins.getInstance();
                            ProxyConfiguration result = jenkins != null ? jenkins.proxy : null;
                            return result;
                        }
                    });
                }
                catch (Throwable throwable) {
                    throw new Error(throwable);
                }
            } else {
                proxyConfiguration = null;
            }
        } else {
            proxyConfiguration = jenkins.proxy;
        }
        return proxyConfiguration;
    }

    public Project getProject(String projectPath) {
        if (!this.projects.containsKey(projectPath)) {
            this.projects.put(projectPath, new Project(this, projectPath));
        }
        return this.projects.get(projectPath);
    }

    public Workspaces getWorkspaces() {
        if (this.workspaces == null) {
            this.workspaces = new Workspaces(this);
        }
        return this.workspaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"DC_DOUBLECHECK", "IS2_INCONSISTENT_SYNC"}, justification="Only synchronize if not null")
    public MockableVersionControlClient getVersionControlClient() {
        if (this.mockableVcc == null) {
            Server server = this;
            synchronized (server) {
                if (this.mockableVcc == null) {
                    VersionControlClient vcc = this.tpc.getVersionControlClient();
                    this.mockableVcc = new MockableVersionControlClient(vcc);
                }
            }
        }
        return this.mockableVcc;
    }

    public HttpClient getHttpClient() {
        return this.tpc.getHTTPClient();
    }

    public <T, E extends Exception> T execute(Callable<T, E> callable) {
        try {
            VirtualChannel channel = this.launcher.getChannel();
            Object result = channel.call(callable);
            return (T)result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public String getUserPassword() {
        return this.userPassword;
    }

    public Launcher getLauncher() {
        return this.launcher;
    }

    @Override
    public WebProxySettings getWebProxySettings() {
        return this.webProxySettings;
    }

    @Override
    public ExtraSettings getExtraSettings() {
        return this.extraSettings;
    }

    @Override
    public TaskListener getListener() {
        return this.taskListener;
    }

    public synchronized void close() {
        if (this.mockableVcc != null) {
            this.mockableVcc.close();
        }
        if (this.tpc != null) {
            try {
                Field f = TFSTeamProjectCollection.class.getDeclaredField("configurationServer");
                f.setAccessible(true);
                TFSConfigurationServer configurationServer = (TFSConfigurationServer)f.get(this.tpc);
                if (configurationServer != null) {
                    configurationServer.close();
                }
                f.setAccessible(false);
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            this.tpc.close();
        }
    }

    public IIdentityManagementService createIdentityManagementService() {
        Object ims;
        try {
            ims = new IdentityManagementService((TFSConnection)this.tpc);
        }
        catch (IdentityManagementException e) {
            ims = new LegacyIdentityManagementService();
        }
        return ims;
    }
}

