/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.model;

import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Change;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Changeset;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.ChangesetVersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.DateVersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.LatestVersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.VersionSpec;
import com.microsoft.tfs.core.clients.webservices.IIdentityManagementService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.User;
import hudson.plugins.tfs.TeamPluginGlobalConfig;
import hudson.plugins.tfs.commands.GetFilesToWorkFolderCommand;
import hudson.plugins.tfs.commands.RemoteChangesetVersionCommand;
import hudson.plugins.tfs.model.ChangeSet;
import hudson.plugins.tfs.model.MockableVersionControlClient;
import hudson.plugins.tfs.model.Server;
import hudson.plugins.tfs.model.TfsUserLookup;
import hudson.plugins.tfs.model.UserAccountMapper;
import hudson.plugins.tfs.model.UserLookup;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class Project {
    private final String projectPath;
    private final Server server;
    private UserLookup userLookup;

    public Project(Server server, String projectPath) {
        this.server = server;
        this.projectPath = projectPath;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    static ChangeSet.Item convertServerChange(Change serverChange) {
        String path = serverChange.getItem().getServerItem();
        String action = serverChange.getChangeType().toUIString(true);
        ChangeSet.Item result = new ChangeSet.Item(path, action);
        return result;
    }

    public static ChangeSet convertServerChangeset(Changeset serverChangeset, UserLookup userLookup) {
        Change[] serverChanges;
        String version = Integer.toString(serverChangeset.getChangesetID(), 10);
        Date date = serverChangeset.getDate().getTime();
        String author = serverChangeset.getOwner();
        User authorUser = userLookup.find(author);
        String comment = serverChangeset.getComment();
        ChangeSet result = new ChangeSet(version, date, authorUser, comment);
        for (Change serverChange : serverChanges = serverChangeset.getChanges()) {
            ChangeSet.Item item = Project.convertServerChange(serverChange);
            result.add(item);
        }
        return result;
    }

    public List<ChangeSet> getVCCHistory(VersionSpec fromVersion, VersionSpec toVersion, boolean includeFileDetails, int maxCount) {
        UserLookup userLookup = this.getOrCreateUserLookup();
        MockableVersionControlClient vcc = this.server.getVersionControlClient();
        Changeset[] serverChangesets = vcc.queryHistory(this.projectPath, fromVersion != null ? fromVersion : toVersion, 0, RecursionType.FULL, null, fromVersion, toVersion, maxCount, includeFileDetails, true, false, false);
        ArrayList<ChangeSet> result = new ArrayList<ChangeSet>();
        if (serverChangesets != null) {
            for (Changeset serverChangeset : serverChangesets) {
                ChangeSet changeSet = Project.convertServerChangeset(serverChangeset, userLookup);
                result.add(changeSet);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"DC_DOUBLECHECK"}, justification="Only synchronize if not null")
    public UserLookup getOrCreateUserLookup() {
        if (this.userLookup == null) {
            Project project = this;
            synchronized (project) {
                if (this.userLookup == null) {
                    IIdentityManagementService ims = this.server.createIdentityManagementService();
                    TeamPluginGlobalConfig teamPluginGlobalConfig = TeamPluginGlobalConfig.get();
                    UserAccountMapper mapper = teamPluginGlobalConfig.getUserAccountMapper();
                    this.userLookup = new TfsUserLookup(ims, mapper);
                }
            }
        }
        return this.userLookup;
    }

    public List<ChangeSet> getDetailedHistory(Calendar fromTimestamp, Calendar toTimestamp) {
        DateVersionSpec fromVersion = new DateVersionSpec(fromTimestamp);
        DateVersionSpec toVersion = new DateVersionSpec(toTimestamp);
        return this.getVCCHistory((VersionSpec)fromVersion, (VersionSpec)toVersion, true, Integer.MAX_VALUE);
    }

    public List<ChangeSet> getDetailedHistory(String singleVersionSpec) {
        VersionSpec toVersion = VersionSpec.parseSingleVersionFromSpec((String)singleVersionSpec, null);
        return this.getVCCHistory(toVersion, toVersion, true, 1);
    }

    public List<ChangeSet> getBriefHistory(Calendar fromTimestamp, Calendar toTimestamp) {
        DateVersionSpec fromVersion = new DateVersionSpec(fromTimestamp);
        DateVersionSpec toVersion = new DateVersionSpec(toTimestamp);
        return this.getVCCHistory((VersionSpec)fromVersion, (VersionSpec)toVersion, false, Integer.MAX_VALUE);
    }

    public List<ChangeSet> getBriefHistory(int fromChangeset, Calendar toTimestamp) {
        ChangesetVersionSpec fromVersion = new ChangesetVersionSpec(fromChangeset);
        DateVersionSpec toVersion = new DateVersionSpec(toTimestamp);
        return this.getVCCHistory((VersionSpec)fromVersion, (VersionSpec)toVersion, false, Integer.MAX_VALUE);
    }

    public ChangeSet getLatestChangeset() {
        List<ChangeSet> changeSets = this.getVCCHistory((VersionSpec)LatestVersionSpec.INSTANCE, null, false, 1);
        ChangeSet result = changeSets.size() > 0 ? changeSets.get(0) : null;
        return result;
    }

    public ChangeSet getLatestUncloakedChangeset(int fromChangeset, Collection<String> cloakedPaths) {
        ChangesetVersionSpec fromVersion = new ChangesetVersionSpec(fromChangeset);
        List<ChangeSet> changeSets = this.getVCCHistory((VersionSpec)fromVersion, (VersionSpec)LatestVersionSpec.INSTANCE, true, Integer.MAX_VALUE);
        ChangeSet result = Project.findLatestUncloakedChangeset(cloakedPaths, changeSets);
        return result;
    }

    static ChangeSet findLatestUncloakedChangeset(Collection<String> cloakedPaths, List<ChangeSet> changeSets) {
        ChangeSet result = null;
        int lastChangeSetNumber = Integer.MAX_VALUE;
        for (ChangeSet s : changeSets) {
            String stringVersion = s.getVersion();
            int changeSetNumber = Integer.parseInt(stringVersion, 10);
            if (changeSetNumber >= lastChangeSetNumber) {
                throw new IllegalArgumentException("The changeset numbers must be strictly decreasing.");
            }
            lastChangeSetNumber = changeSetNumber;
            Collection<String> changes = s.getAffectedPaths();
            boolean fullyCloaked = Project.isChangesetFullyCloaked(changes, cloakedPaths);
            if (fullyCloaked) continue;
            result = s;
            break;
        }
        return result;
    }

    public List<ChangeSet> getDetailedHistoryWithoutCloakedPaths(Calendar fromTimestamp, Calendar toTimestamp, Collection<String> cloakedPaths) {
        DateVersionSpec fromVersion = new DateVersionSpec(fromTimestamp);
        DateVersionSpec toVersion = new DateVersionSpec(toTimestamp);
        return this.getDetailedHistoryWithoutCloakedPaths((VersionSpec)fromVersion, (VersionSpec)toVersion, cloakedPaths);
    }

    public List<ChangeSet> getDetailedHistoryWithoutCloakedPaths(VersionSpec fromVersion, VersionSpec toVersion, Collection<String> cloakedPaths) {
        List<ChangeSet> changeSets = this.getVCCHistory(fromVersion, toVersion, true, Integer.MAX_VALUE);
        ArrayList<ChangeSet> changeSetNoCloaked = new ArrayList<ChangeSet>();
        for (ChangeSet changeset : changeSets) {
            Collection<String> affectedPaths = changeset.getAffectedPaths();
            boolean fullyCloaked = Project.isChangesetFullyCloaked(affectedPaths, cloakedPaths);
            if (fullyCloaked) continue;
            changeSetNoCloaked.add(changeset);
        }
        return changeSetNoCloaked;
    }

    static boolean isChangesetFullyCloaked(Collection<String> changesetPaths, Collection<String> cloakedPaths) {
        if (cloakedPaths == null) {
            return false;
        }
        for (String tfsPath : changesetPaths) {
            boolean isPathCloaked = false;
            for (String cloakedPath : cloakedPaths) {
                if (!tfsPath.regionMatches(true, 0, cloakedPath, 0, cloakedPath.length())) continue;
                isPathCloaked = true;
                break;
            }
            if (isPathCloaked) continue;
            return false;
        }
        return true;
    }

    public void getFiles(String localPath, String versionSpec, boolean useOverwrite) {
        GetFilesToWorkFolderCommand command = new GetFilesToWorkFolderCommand(this.server, localPath, versionSpec, useOverwrite);
        this.server.execute(command.getCallable());
    }

    public int getRemoteChangesetVersion(String remotePath, VersionSpec versionSpec) {
        RemoteChangesetVersionCommand command = new RemoteChangesetVersionCommand(this.server, remotePath, versionSpec);
        return this.extractChangesetNumber(command);
    }

    int extractChangesetNumber(RemoteChangesetVersionCommand command) {
        Integer changeSet = this.server.execute(command.getCallable());
        int result = changeSet;
        return result;
    }

    public int getRemoteChangesetVersion(VersionSpec versionSpec) {
        return this.getRemoteChangesetVersion(this.projectPath, versionSpec);
    }

    public int hashCode() {
        return new HashCodeBuilder(13, 27).append((Object)this.projectPath).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Project other = (Project)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.projectPath, (Object)other.projectPath);
        return builder.isEquals();
    }

    protected UserLookup getUserLookup() {
        return this.userLookup;
    }

    protected void setUserLookup(UserLookup userLookup) {
        this.userLookup = userLookup;
    }
}

