/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.model;

import com.microsoft.tfs.core.persistence.PersistenceStore;
import hudson.plugins.tfs.model.NativeLibraryExtractor;
import hudson.plugins.tfs.model.UserHomePersistenceStore;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;

public class NativeLibraryManager
implements NativeLibraryExtractor {
    private static final String VENDOR_NAME = "Microsoft";
    private static final String TFS_SDK = "TFS_SDK";
    private static final String VERSION = "14.0.1";
    private static final String nativeFolderPropertyName = "com.microsoft.tfs.jni.native.base-directory";
    private static final String NATIVE = "native";
    private static final Class<NativeLibraryManager> metaClass = NativeLibraryManager.class;
    private static final TreeMap<String, TreeMap<String, List<String>>> NATIVE_LIBRARIES = new TreeMap();
    private final PersistenceStore store;

    public NativeLibraryManager(PersistenceStore store) {
        this.store = store;
    }

    public void extractFiles() throws IOException {
        NativeLibraryManager.extractFiles(this);
    }

    static void extractFiles(NativeLibraryExtractor extractor) throws IOException {
        for (Map.Entry<String, TreeMap<String, List<String>>> nativeLibrary : NATIVE_LIBRARIES.entrySet()) {
            TreeMap<String, List<String>> architecturesToFileNames = nativeLibrary.getValue();
            for (Map.Entry<String, List<String>> architectureToFilename : architecturesToFileNames.entrySet()) {
                List<String> fileNames = architectureToFilename.getValue();
                for (String fileName : fileNames) {
                    extractor.extractFile(nativeLibrary.getKey(), architectureToFilename.getKey(), fileName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void extractFile(String operatingSystem, String architecture, String fileName) throws IOException {
        String pathToNativeFile = NativeLibraryManager.buildPathToNativeFile(operatingSystem, architecture, fileName);
        if (!this.store.containsItem(pathToNativeFile)) {
            InputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                inputStream = metaClass.getResourceAsStream(pathToNativeFile);
                outputStream = this.store.getItemOutputStream(pathToNativeFile);
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((InputStream)inputStream);
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }

    static String buildPathToNativeFile(String operatingSystem, String architecture, String fileName) {
        StringBuilder sb = new StringBuilder(NATIVE.length() + 1 + operatingSystem.length() + 1 + 7 + 1 + fileName.length());
        sb.append(NATIVE).append('/');
        sb.append(operatingSystem).append('/');
        if (architecture != null) {
            sb.append(architecture).append('/');
        }
        sb.append(fileName);
        String result = sb.toString();
        return result;
    }

    public static synchronized void initialize() throws IOException {
        String nativeFolder = System.getProperty(nativeFolderPropertyName);
        if (nativeFolder == null) {
            File vendor = new File(VENDOR_NAME);
            File vendor_sdk = new File(vendor, TFS_SDK);
            File vendor_sdk_version = new File(vendor_sdk, VERSION);
            UserHomePersistenceStore store = new UserHomePersistenceStore(vendor_sdk_version);
            NativeLibraryManager manager = new NativeLibraryManager((PersistenceStore)store);
            manager.extractFiles();
            File storeFile = store.getStoreFile();
            File nativeFile = new File(storeFile, NATIVE);
            String absolutePath = nativeFile.getAbsolutePath();
            System.setProperty(nativeFolderPropertyName, absolutePath);
        }
    }

    static {
        TreeMap<String, List<String>> aix = new TreeMap<String, List<String>>();
        List<String> aix_ppc = Arrays.asList("libnative_auth.a", "libnative_console.a", "libnative_filesystem.a", "libnative_misc.a", "libnative_synchronization.a");
        aix.put("ppc", aix_ppc);
        NATIVE_LIBRARIES.put("aix", aix);
        TreeMap<String, List<String>> freebsd = new TreeMap<String, List<String>>();
        List<String> freebsd_x86 = Arrays.asList("libnative_auth.so", "libnative_console.so", "libnative_filesystem.so", "libnative_misc.so", "libnative_synchronization.so");
        freebsd.put("x86", freebsd_x86);
        List<String> freebsd_x86_64 = Arrays.asList("libnative_auth.so", "libnative_console.so", "libnative_filesystem.so", "libnative_misc.so", "libnative_synchronization.so");
        freebsd.put("x86_64", freebsd_x86_64);
        NATIVE_LIBRARIES.put("freebsd", freebsd);
        TreeMap<String, List<String>> hpux = new TreeMap<String, List<String>>();
        List<String> hpux_ia64_32 = Arrays.asList("libnative_auth.so", "libnative_console.so", "libnative_filesystem.so", "libnative_misc.so", "libnative_synchronization.so");
        hpux.put("ia64_32", hpux_ia64_32);
        List<String> hpux_PA_RISC = Arrays.asList("libnative_auth.sl", "libnative_console.sl", "libnative_filesystem.sl", "libnative_misc.sl", "libnative_synchronization.sl");
        hpux.put("PA_RISC", hpux_PA_RISC);
        NATIVE_LIBRARIES.put("hpux", hpux);
        TreeMap<String, List<String>> linux = new TreeMap<String, List<String>>();
        List<String> linux_arm = Arrays.asList("libnative_auth.so", "libnative_console.so", "libnative_filesystem.so", "libnative_misc.so", "libnative_synchronization.so");
        linux.put("arm", linux_arm);
        List<String> linux_ppc = Arrays.asList("libnative_auth.so", "libnative_console.so", "libnative_filesystem.so", "libnative_misc.so", "libnative_synchronization.so");
        linux.put("ppc", linux_ppc);
        List<String> linux_x86 = Arrays.asList("libnative_auth.so", "libnative_console.so", "libnative_filesystem.so", "libnative_misc.so", "libnative_synchronization.so");
        linux.put("x86", linux_x86);
        List<String> linux_x86_64 = Arrays.asList("libnative_auth.so", "libnative_console.so", "libnative_filesystem.so", "libnative_misc.so", "libnative_synchronization.so");
        linux.put("x86_64", linux_x86_64);
        NATIVE_LIBRARIES.put("linux", linux);
        TreeMap<String, List<String>> macosx = new TreeMap<String, List<String>>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return 0;
            }
        });
        List<String> macosx_universal = Arrays.asList("libnative_auth.jnilib", "libnative_console.jnilib", "libnative_filesystem.jnilib", "libnative_keychain.jnilib", "libnative_misc.jnilib", "libnative_synchronization.jnilib");
        macosx.put(null, macosx_universal);
        NATIVE_LIBRARIES.put("macosx", macosx);
        TreeMap<String, List<String>> solaris = new TreeMap<String, List<String>>();
        List<String> solaris_sparc = Arrays.asList("libnative_auth.so", "libnative_console.so", "libnative_filesystem.so", "libnative_misc.so", "libnative_synchronization.so");
        solaris.put("sparc", solaris_sparc);
        List<String> solaris_x86 = Arrays.asList("libnative_auth.so", "libnative_console.so", "libnative_filesystem.so", "libnative_misc.so", "libnative_synchronization.so");
        solaris.put("x86", solaris_x86);
        List<String> solaris_x86_64 = Arrays.asList("libnative_auth.so", "libnative_console.so", "libnative_filesystem.so", "libnative_misc.so", "libnative_synchronization.so");
        solaris.put("x86_64", solaris_x86_64);
        NATIVE_LIBRARIES.put("solaris", solaris);
        TreeMap<String, List<String>> win32 = new TreeMap<String, List<String>>();
        List<String> win32_x86 = Arrays.asList("native_auth.dll", "native_console.dll", "native_credential.dll", "native_filesystem.dll", "native_messagewindow.dll", "native_misc.dll", "native_registry.dll", "native_synchronization.dll");
        win32.put("x86", win32_x86);
        List<String> win32_x86_64 = Arrays.asList("native_auth.dll", "native_console.dll", "native_credential.dll", "native_filesystem.dll", "native_messagewindow.dll", "native_misc.dll", "native_registry.dll", "native_synchronization.dll");
        win32.put("x86_64", win32_x86_64);
        NATIVE_LIBRARIES.put("win32", win32);
    }
}

