/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.model;

import com.microsoft.tfs.core.config.ConnectionInstanceData;
import com.microsoft.tfs.core.config.httpclient.DefaultHTTPClientFactory;
import com.microsoft.tfs.core.httpclient.Credentials;
import com.microsoft.tfs.core.httpclient.DefaultNTCredentials;
import com.microsoft.tfs.core.httpclient.HostConfiguration;
import com.microsoft.tfs.core.httpclient.HttpClient;
import com.microsoft.tfs.core.httpclient.HttpState;
import com.microsoft.tfs.core.httpclient.ProxyHost;
import com.microsoft.tfs.core.httpclient.UsernamePasswordCredentials;
import com.microsoft.tfs.core.httpclient.auth.AuthScope;
import hudson.plugins.tfs.model.ProxyHostEx;
import hudson.util.Secret;

public class ModernHTTPClientFactory
extends DefaultHTTPClientFactory {
    private final ProxyHostEx proxyHost;

    public ModernHTTPClientFactory(ConnectionInstanceData connectionInstanceData) {
        this(connectionInstanceData, null);
    }

    public ModernHTTPClientFactory(ConnectionInstanceData connectionInstanceData, ProxyHostEx proxyHost) {
        super(connectionInstanceData);
        this.proxyHost = proxyHost;
    }

    protected String getUserAgentExtraString(HttpClient httpClient, ConnectionInstanceData connectionInstanceData) {
        Class<?> me = ((Object)((Object)this)).getClass();
        Package us = me.getPackage();
        String version = us.getImplementationVersion();
        if (version == null) {
            version = "devtest";
        }
        return "TFS-Jenkins " + version;
    }

    public void configureClientProxy(HttpClient httpClient, HostConfiguration hostConfiguration, HttpState httpState, ConnectionInstanceData connectionInstanceData) {
        hostConfiguration.setProxyHost((ProxyHost)this.proxyHost);
        if (this.proxyHost != null) {
            String proxyUser = this.proxyHost.getProxyUser();
            Secret proxySecret = this.proxyHost.getProxySecret();
            if (proxyUser != null && proxySecret != null) {
                httpState.setProxyCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(proxyUser, proxySecret.getPlainText()));
            } else {
                httpState.setProxyCredentials(AuthScope.ANY, (Credentials)new DefaultNTCredentials());
            }
        }
    }
}

