/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.model;

import com.microsoft.tfs.core.config.ConnectionInstanceData;
import com.microsoft.tfs.core.config.DefaultConnectionAdvisor;
import com.microsoft.tfs.core.config.httpclient.HTTPClientFactory;
import com.microsoft.tfs.core.config.persistence.DefaultPersistenceStoreProvider;
import com.microsoft.tfs.core.config.persistence.PersistenceStoreProvider;
import hudson.plugins.tfs.model.ModernHTTPClientFactory;
import hudson.plugins.tfs.model.ProxyHostEx;
import java.util.Locale;
import java.util.TimeZone;

public class ModernConnectionAdvisor
extends DefaultConnectionAdvisor {
    private final ProxyHostEx proxyHost;
    private final PersistenceStoreProvider persistenceStoreProvider;

    public ModernConnectionAdvisor(ProxyHostEx proxyHost) {
        this(proxyHost, null);
    }

    public ModernConnectionAdvisor(ProxyHostEx proxyHost, PersistenceStoreProvider persistenceStoreProvider) {
        super(Locale.getDefault(), TimeZone.getDefault());
        this.proxyHost = proxyHost;
        this.persistenceStoreProvider = persistenceStoreProvider;
    }

    public PersistenceStoreProvider getPersistenceStoreProvider(ConnectionInstanceData instanceData) {
        return this.persistenceStoreProvider != null ? this.persistenceStoreProvider : DefaultPersistenceStoreProvider.INSTANCE;
    }

    public HTTPClientFactory getHTTPClientFactory(ConnectionInstanceData connectionInstanceData) {
        return new ModernHTTPClientFactory(connectionInstanceData, this.proxyHost);
    }
}

