/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.model;

import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspaceLocation;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspaceOptions;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspacePermissions;
import com.microsoft.tfs.core.clients.versioncontrol.events.VersionControlEventEngine;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.ItemNotMappedException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.ServerPathFormatException;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Changeset;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LabelChildOption;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LabelResult;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.VersionControlLabel;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.WorkingFolder;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.clients.versioncontrol.specs.LabelItemSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.VersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.workspacecache.WorkspaceInfo;
import com.microsoft.tfs.util.Closable;
import javax.annotation.Nonnull;

public class MockableVersionControlClient
implements Closable {
    private final VersionControlClient vcc;
    private boolean isClosed = false;

    public MockableVersionControlClient(VersionControlClient vcc) {
        this.vcc = vcc;
    }

    public void close() {
        if (!this.isClosed) {
            this.vcc.close();
            this.isClosed = true;
        }
    }

    private void makeSureNotClosed() {
        if (this.isClosed) {
            throw new UnsupportedOperationException("Instance has been closed and can no longer be used.");
        }
    }

    public LabelResult[] createLabel(VersionControlLabel label, LabelItemSpec[] items, LabelChildOption options) {
        this.makeSureNotClosed();
        return this.vcc.createLabel(label, items, options);
    }

    public Workspace createWorkspace(WorkingFolder[] workingFolders, String workspaceName, String owner, String ownerDisplayName, String comment, WorkspaceLocation location, WorkspaceOptions options) {
        this.makeSureNotClosed();
        return this.vcc.createWorkspace(workingFolders, workspaceName, owner, ownerDisplayName, comment, location, options);
    }

    public void deleteWorkspace(Workspace workspace) {
        this.makeSureNotClosed();
        this.vcc.deleteWorkspace(workspace);
    }

    public TFSTeamProjectCollection getConnection() {
        this.makeSureNotClosed();
        return this.vcc.getConnection();
    }

    public VersionControlEventEngine getEventEngine() {
        this.makeSureNotClosed();
        return this.vcc.getEventEngine();
    }

    public Workspace getLocalWorkspace(String workspaceName, String workspaceOwner) {
        this.makeSureNotClosed();
        return this.vcc.getLocalWorkspace(workspaceName, workspaceOwner);
    }

    public int getLatestChangesetID() {
        this.makeSureNotClosed();
        return this.vcc.getLatestChangesetID();
    }

    public Workspace getWorkspace(String localPath) throws ItemNotMappedException {
        this.makeSureNotClosed();
        return this.vcc.getWorkspace(localPath);
    }

    public Changeset[] queryHistory(String serverOrLocalPath, VersionSpec version, int deletionID, RecursionType recursion, String user, VersionSpec versionFrom, VersionSpec versionTo, int maxCount, boolean includeFileDetails, boolean slotMode, boolean includeDownloadInfo, boolean sortAscending) throws ServerPathFormatException {
        this.makeSureNotClosed();
        return this.vcc.queryHistory(serverOrLocalPath, version, deletionID, recursion, user, versionFrom, versionTo, maxCount, includeFileDetails, slotMode, includeDownloadInfo, sortAscending);
    }

    public VersionControlLabel[] queryLabels(String label, String scope, String owner, boolean includeItemDetails, String filterItem, VersionSpec filterItemVersion) {
        this.makeSureNotClosed();
        return this.vcc.queryLabels(label, scope, owner, includeItemDetails, filterItem, filterItemVersion);
    }

    public Workspace queryWorkspace(String name, String owner) {
        this.makeSureNotClosed();
        return this.vcc.queryWorkspace(name, owner);
    }

    public Workspace[] queryWorkspaces(String workspaceName, String workspaceOwner, String computer, @Nonnull WorkspacePermissions permissionsFilter) {
        this.makeSureNotClosed();
        return this.vcc.queryWorkspaces(workspaceName, workspaceOwner, computer, permissionsFilter);
    }

    public WorkspaceInfo removeCachedWorkspace(String workspaceName, String workspaceOwner) {
        this.makeSureNotClosed();
        return this.vcc.removeCachedWorkspace(workspaceName, workspaceOwner);
    }

    public Workspace tryGetWorkspace(String localPath) {
        this.makeSureNotClosed();
        return this.vcc.tryGetWorkspace(localPath);
    }
}

