/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.model;

import com.microsoft.tfs.core.httpclient.methods.GetMethod;
import com.microsoft.tfs.core.httpclient.methods.HeadMethod;
import com.microsoft.tfs.core.httpclient.methods.PostMethod;
import com.microsoft.tfs.core.httpclient.methods.RequestEntity;
import com.microsoft.tfs.core.httpclient.methods.StringRequestEntity;
import hudson.plugins.tfs.util.MediaType;
import java.io.UnsupportedEncodingException;

public enum HttpMethod {
    GET{

        @Override
        public com.microsoft.tfs.core.httpclient.HttpMethod createClientMethod(String uri, String body) {
            return new GetMethod(uri);
        }
    }
    ,
    POST,
    HEAD{

        @Override
        public com.microsoft.tfs.core.httpclient.HttpMethod createClientMethod(String uri, String body) {
            return new HeadMethod(uri);
        }
    }
    ,
    PATCH{

        @Override
        public com.microsoft.tfs.core.httpclient.HttpMethod createClientMethod(String uri, String body) {
            return this.innerCreateClientMethod(uri, body, "application/json-patch+json");
        }
    }
    ,
    OPTIONS,
    PUT,
    DELETE,
    TRACE;


    public com.microsoft.tfs.core.httpclient.HttpMethod createClientMethod(String uri, String body) {
        return this.innerCreateClientMethod(uri, body, "application/json");
    }

    PostMethod innerCreateClientMethod(String uri, String body, String contentType) {
        StringRequestEntity requestEntity;
        PostMethod method = new PostMethod(uri);
        method.addRequestHeader("X-HTTP-Method-Override", this.name());
        String charset = MediaType.UTF_8.toString();
        try {
            requestEntity = new StringRequestEntity(body, contentType, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
        method.setRequestEntity((RequestEntity)requestEntity);
        return method;
    }
}

