/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.teamfoundation.core.webapi.model.TeamProjectReference;
import com.microsoft.teamfoundation.sourcecontrol.webapi.model.GitCommitRef;
import com.microsoft.teamfoundation.sourcecontrol.webapi.model.GitPush;
import com.microsoft.teamfoundation.sourcecontrol.webapi.model.GitRefUpdate;
import com.microsoft.teamfoundation.sourcecontrol.webapi.model.GitRepository;
import com.microsoft.visualstudio.services.webapi.model.IdentityRef;
import hudson.model.Action;
import hudson.plugins.git.GitStatus;
import hudson.plugins.tfs.CommitParameterAction;
import hudson.plugins.tfs.model.AbstractHookEvent;
import hudson.plugins.tfs.model.GitCodePushedEventArgs;
import hudson.plugins.tfs.model.servicehooks.Event;
import hudson.plugins.tfs.model.servicehooks.ResourceContainer;
import hudson.plugins.tfs.util.ResourceHelper;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;

public class GitPushEvent
extends AbstractHookEvent {
    @Override
    public JSONObject perform(ObjectMapper mapper, Event serviceHookEvent, String message, String detailedMessage) {
        Object resource = serviceHookEvent.getResource();
        GitPush gitPush = (GitPush)mapper.convertValue(resource, GitPush.class);
        GitCodePushedEventArgs args = GitPushEvent.decodeGitPush(gitPush, serviceHookEvent);
        CommitParameterAction parameterAction = new CommitParameterAction(args);
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add((Action)parameterAction);
        List<GitStatus.ResponseContributor> contributors = this.pollOrQueueFromEvent(args, actions, false);
        JSONObject response = GitPushEvent.fromResponseContributors(contributors);
        return response;
    }

    static URI determineCollectionUri(URI repoApiUri) {
        URI uri;
        String path = repoApiUri.getPath();
        int i = path.indexOf("_apis/");
        if (i == -1) {
            String template = "Repository url '%s' did not contain '_apis/'.";
            throw new IllegalArgumentException(String.format("Repository url '%s' did not contain '_apis/'.", repoApiUri));
        }
        String pathBeforeApis = path.substring(0, i);
        try {
            uri = new URI(repoApiUri.getScheme(), repoApiUri.getAuthority(), pathBeforeApis, repoApiUri.getQuery(), repoApiUri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new Error(e);
        }
        return uri;
    }

    static URI determineCollectionUri(GitRepository repository, Event serviceHookEvent) {
        URI result = null;
        Map<String, ResourceContainer> containers = serviceHookEvent.getResourceContainers();
        if (containers != null) {
            ResourceContainer collectionContainer;
            String baseUrl;
            String collection = "collection";
            if (containers.containsKey("collection") && StringUtils.isNotEmpty((String)(baseUrl = (collectionContainer = containers.get("collection")).getBaseUrl()))) {
                result = URI.create(baseUrl);
            }
        }
        if (result == null) {
            String repoApiUrlString = repository.getUrl();
            URI repoApiUri = URI.create(repoApiUrlString);
            result = GitPushEvent.determineCollectionUri(repoApiUri);
        }
        return result;
    }

    static String determineProjectId(GitRepository repository) {
        TeamProjectReference project = repository.getProject();
        String result = project.getName();
        return result;
    }

    static String determineCommit(GitPush gitPush) {
        List commits = gitPush.getCommits();
        if (commits == null || commits.size() < 1) {
            return null;
        }
        GitCommitRef commit = (GitCommitRef)commits.get(0);
        return commit.getCommitId();
    }

    static String determinePushedBy(GitPush gitPush) {
        IdentityRef pushedBy = gitPush.getPushedBy();
        String result = pushedBy.getDisplayName();
        return result;
    }

    static String determineTargetBranch(GitPush gitPush) {
        String targetBranch = ((GitRefUpdate)gitPush.getRefUpdates().get(0)).getName();
        String[] items = targetBranch.split("/");
        return items[items.length - 1];
    }

    static GitCodePushedEventArgs decodeGitPush(GitPush gitPush, Event serviceHookEvent) {
        GitRepository repository = gitPush.getRepository();
        URI collectionUri = GitPushEvent.determineCollectionUri(repository, serviceHookEvent);
        String repoUriString = repository.getRemoteUrl();
        URI repoUri = URI.create(repoUriString);
        String projectId = GitPushEvent.determineProjectId(repository);
        String repoId = repository.getName();
        String commit = GitPushEvent.determineCommit(gitPush);
        String pushedBy = GitPushEvent.determinePushedBy(gitPush);
        String targetBranch = GitPushEvent.determineTargetBranch(gitPush);
        GitCodePushedEventArgs args = new GitCodePushedEventArgs();
        args.collectionUri = collectionUri;
        args.repoUri = repoUri;
        args.projectId = projectId;
        args.repoId = repoId;
        args.commit = commit;
        args.pushedBy = pushedBy;
        args.targetBranch = targetBranch;
        return args;
    }

    public static class Factory
    implements AbstractHookEvent.Factory {
        @Override
        public AbstractHookEvent create() {
            return new GitPushEvent();
        }

        @Override
        public String getSampleRequestPayload() {
            return ResourceHelper.fetchAsString(this.getClass(), "GitPushEvent.json");
        }
    }
}

