/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.teamfoundation.sourcecontrol.webapi.model.GitCommitRef;
import com.microsoft.teamfoundation.sourcecontrol.webapi.model.GitPullRequest;
import com.microsoft.teamfoundation.sourcecontrol.webapi.model.GitRepository;
import com.microsoft.visualstudio.services.webapi.model.IdentityRef;
import hudson.model.Action;
import hudson.plugins.git.GitStatus;
import hudson.plugins.tfs.PullRequestParameterAction;
import hudson.plugins.tfs.TeamPullRequestMergedDetailsAction;
import hudson.plugins.tfs.model.AbstractHookEvent;
import hudson.plugins.tfs.model.GitPullRequestEx;
import hudson.plugins.tfs.model.GitPushEvent;
import hudson.plugins.tfs.model.PullRequestMergeCommitCreatedEventArgs;
import hudson.plugins.tfs.model.servicehooks.Event;
import hudson.plugins.tfs.util.ResourceHelper;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONObject;

public class GitPullRequestMergedEvent
extends GitPushEvent {
    static String determineCreatedBy(GitPullRequest gitPullRequest) {
        IdentityRef createdBy = gitPullRequest.getCreatedBy();
        String result = createdBy.getDisplayName();
        return result;
    }

    static String determineMergeCommit(GitPullRequest gitPullRequest) {
        GitCommitRef lastMergeCommit = gitPullRequest.getLastMergeCommit();
        String result = lastMergeCommit.getCommitId();
        return result;
    }

    static String determineTargetBranch(GitPullRequest gitPullRequest) {
        String targetRefName = gitPullRequest.getTargetRefName();
        String[] items = targetRefName.split("/");
        return items[items.length - 1];
    }

    @Override
    public JSONObject perform(ObjectMapper mapper, Event serviceHookEvent, String message, String detailedMessage) {
        Object resource = serviceHookEvent.getResource();
        GitPullRequestEx gitPullRequest = (GitPullRequestEx)((Object)mapper.convertValue(resource, GitPullRequestEx.class));
        PullRequestMergeCommitCreatedEventArgs args = GitPullRequestMergedEvent.decodeGitPullRequest(gitPullRequest, serviceHookEvent);
        PullRequestParameterAction parameterAction = new PullRequestParameterAction(args);
        TeamPullRequestMergedDetailsAction teamPullRequestMergedDetailsAction = new TeamPullRequestMergedDetailsAction(gitPullRequest, message, detailedMessage, args.collectionUri.toString());
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add((Action)parameterAction);
        actions.add(teamPullRequestMergedDetailsAction);
        List<GitStatus.ResponseContributor> contributors = this.pollOrQueueFromEvent(args, actions, true);
        JSONObject response = GitPullRequestMergedEvent.fromResponseContributors(contributors);
        return response;
    }

    static PullRequestMergeCommitCreatedEventArgs decodeGitPullRequest(GitPullRequest gitPullRequest, Event serviceHookEvent) {
        GitRepository repository = gitPullRequest.getRepository();
        URI collectionUri = GitPullRequestMergedEvent.determineCollectionUri(repository, serviceHookEvent);
        String repoUriString = repository.getRemoteUrl();
        URI repoUri = URI.create(repoUriString);
        String projectId = GitPullRequestMergedEvent.determineProjectId(repository);
        String repoId = repository.getName();
        String commit = GitPullRequestMergedEvent.determineMergeCommit(gitPullRequest);
        String pushedBy = GitPullRequestMergedEvent.determineCreatedBy(gitPullRequest);
        int pullRequestId = gitPullRequest.getPullRequestId();
        String targetBranch = GitPullRequestMergedEvent.determineTargetBranch(gitPullRequest);
        PullRequestMergeCommitCreatedEventArgs args = new PullRequestMergeCommitCreatedEventArgs();
        args.collectionUri = collectionUri;
        args.repoUri = repoUri;
        args.projectId = projectId;
        args.repoId = repoId;
        args.commit = commit;
        args.pushedBy = pushedBy;
        args.pullRequestId = pullRequestId;
        args.targetBranch = targetBranch;
        return args;
    }

    public static class Factory
    implements AbstractHookEvent.Factory {
        @Override
        public AbstractHookEvent create() {
            return new GitPullRequestMergedEvent();
        }

        @Override
        public String getSampleRequestPayload() {
            return ResourceHelper.fetchAsString(this.getClass(), "GitPullRequestMergedEvent.json");
        }
    }
}

