/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.plugins.tfs.TeamCollectionConfiguration;
import hudson.plugins.tfs.TeamPluginGlobalConfig;
import hudson.plugins.tfs.model.AbstractHookEvent;
import hudson.plugins.tfs.model.ConnectionParameters;
import hudson.plugins.tfs.model.servicehooks.Event;
import java.net.URI;
import net.sf.json.JSONObject;

public class ConnectHookEvent
extends AbstractHookEvent {
    @Override
    public JSONObject perform(ObjectMapper mapper, Event serviceHookEvent, String message, String detailedMessage) {
        Object resource = serviceHookEvent.getResource();
        ConnectionParameters parameters = (ConnectionParameters)mapper.convertValue(resource, ConnectionParameters.class);
        TeamCollectionConfiguration collection = TeamCollectionConfiguration.findCollection(URI.create(parameters.getTeamCollectionUrl()));
        if (collection == null) {
            throw new IllegalArgumentException("Unable to connect to unknown server: " + parameters.getTeamCollectionUrl());
        }
        collection.getConnectionParameters().setConnectionKey(parameters.getConnectionKey());
        collection.getConnectionParameters().setConnectionSignature(parameters.getConnectionSignature());
        collection.getConnectionParameters().setSendJobCompletionEvents(parameters.isSendJobCompletionEvents());
        collection.getConnectionParameters().setTeamCollectionUrl(parameters.getTeamCollectionUrl());
        TeamPluginGlobalConfig config = TeamPluginGlobalConfig.get();
        config.save();
        return JSONObject.fromObject((Object)serviceHookEvent);
    }

    public static class Factory
    implements AbstractHookEvent.Factory {
        @Override
        public AbstractHookEvent create() {
            return new ConnectHookEvent();
        }

        @Override
        public String getSampleRequestPayload() {
            return "{\n    \"eventType\": \"connect\",\n    \"resource\":\n    {\n        \"teamCollectionUrl\": \"https://xplatalm.visualstudio.com\"\n        \"connectionKey\": \"MyJenkinsServer\"\n        \"connectionSignature\": \"ABC13ABC123ABC13ABC123ABC13ABC123\"\n        \"sendJobCompletionEvents\": true\n    }\n}";
        }
    }
}

