/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.model;

import com.microsoft.tfs.core.config.persistence.PersistenceStoreProvider;
import com.microsoft.tfs.core.persistence.FilesystemPersistenceStore;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class ClonePersistenceStoreProvider
implements PersistenceStoreProvider {
    private final FilesystemPersistenceStore cacheStore;
    private final FilesystemPersistenceStore configurationStore;
    private final FilesystemPersistenceStore logStore;
    private final String hostName;

    public ClonePersistenceStoreProvider(PersistenceStoreProvider sourcePersistenceStoreProvider, String hostName) {
        this.hostName = hostName;
        FilesystemPersistenceStore sourceCache = sourcePersistenceStoreProvider.getCachePersistenceStore();
        File cacheFolder = ClonePersistenceStoreProvider.createAndCopy(sourceCache, hostName);
        this.cacheStore = new FilesystemPersistenceStore(cacheFolder);
        FilesystemPersistenceStore sourceConfiguration = sourcePersistenceStoreProvider.getConfigurationPersistenceStore();
        File configurationFolder = ClonePersistenceStoreProvider.createAndCopy(sourceConfiguration, hostName);
        this.configurationStore = new FilesystemPersistenceStore(configurationFolder);
        FilesystemPersistenceStore sourceLog = sourcePersistenceStoreProvider.getLogPersistenceStore();
        File logFolder = ClonePersistenceStoreProvider.createAndCopy(sourceLog, hostName);
        this.logStore = new FilesystemPersistenceStore(logFolder);
    }

    static File createAndCopy(FilesystemPersistenceStore sourceStore, String nodeName) {
        File sourceBase = sourceStore.getStoreFile();
        String childName = sourceBase.getName();
        File sourceParent = sourceBase.getParentFile();
        File destinationBase = new File(sourceParent, nodeName);
        File destination = new File(destinationBase, childName);
        if (!destination.isDirectory() && sourceBase.isDirectory()) {
            try {
                FileUtils.copyDirectory((File)sourceBase, (File)destination);
            }
            catch (IOException e) {
                throw new Error(e);
            }
        }
        return destination;
    }

    public FilesystemPersistenceStore getCachePersistenceStore() {
        return this.cacheStore;
    }

    public FilesystemPersistenceStore getConfigurationPersistenceStore() {
        return this.configurationStore;
    }

    public FilesystemPersistenceStore getLogPersistenceStore() {
        return this.logStore;
    }

    public String getHostName() {
        return this.hostName;
    }
}

