/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.model;

import hudson.model.User;
import hudson.plugins.tfs.model.ChangeLogSet;
import hudson.plugins.tfs.util.DateUtil;
import hudson.scm.ChangeLogSet;
import hudson.scm.EditType;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=999)
public class ChangeSet
extends ChangeLogSet.Entry {
    private User authorUser;
    private User checkedInByUser;
    private String version;
    private String userString;
    private String domain;
    private Date date;
    private String comment;
    private List<Item> items;
    private String checkedInByUserString;

    public ChangeSet() {
        this("", null, "", "");
    }

    public ChangeSet(String version, Date date, String userString, String comment) {
        this.version = version;
        this.date = date != null ? new Date(date.getTime()) : null;
        this.comment = comment;
        this.items = new ArrayList<Item>();
        this.setUser(userString);
    }

    public ChangeSet(String version, Date date, User author, String comment) {
        this.version = version;
        this.date = date != null ? new Date(date.getTime()) : null;
        this.authorUser = author;
        this.userString = author.getId();
        this.comment = comment;
        this.items = new ArrayList<Item>();
    }

    public Collection<String> getAffectedPaths() {
        ArrayList<String> paths = new ArrayList<String>(this.items.size());
        for (Item item : this.items) {
            paths.add(item.getPath());
        }
        return paths;
    }

    public Collection<? extends ChangeLogSet.AffectedFile> getAffectedFiles() {
        return this.items;
    }

    public ChangeLogSet getParent() {
        return (ChangeLogSet)super.getParent();
    }

    public User getAuthor() {
        if (this.authorUser == null) {
            this.authorUser = User.get((String)this.userString);
        }
        return this.authorUser;
    }

    public String getMsg() {
        return this.comment;
    }

    @Exported
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Exported
    public String getCommitId() {
        return this.version;
    }

    @Exported
    public String getDomain() {
        return this.domain;
    }

    @Exported
    public String getUser() {
        return this.userString;
    }

    public void setUser(String user) {
        String[] split = user.split("\\\\");
        if (split.length == 2) {
            this.domain = split[0];
            this.userString = split[1];
        } else {
            this.userString = user;
            this.domain = null;
        }
    }

    @Exported
    public Date getDate() {
        if (this.date != null) {
            return new Date(this.date.getTime());
        }
        return null;
    }

    public void setDateStr(String dateStr) throws ParseException {
        this.date = DateUtil.TFS_DATETIME_FORMATTER.get().parse(dateStr);
    }

    @Exported
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setCheckedInBy(String checkedInByUserString) {
        if (checkedInByUserString != null) {
            String[] split = checkedInByUserString.split("\\\\");
            this.checkedInByUserString = split.length == 2 ? split[1] : checkedInByUserString;
        }
    }

    public String getCheckedInBy() {
        return this.checkedInByUserString;
    }

    public User getCheckedInByUser() {
        if (this.checkedInByUser == null) {
            this.checkedInByUser = User.get((String)this.checkedInByUserString);
        }
        return this.checkedInByUser;
    }

    public void setCheckedInByUser(User checkedInBy) {
        this.checkedInByUser = checkedInBy;
    }

    @Exported
    public List<Item> getItems() {
        return this.items;
    }

    public void add(Item item) {
        this.items.add(item);
        item.setParent(this);
    }

    protected void setParent(hudson.scm.ChangeLogSet parent) {
        super.setParent(parent);
    }

    @ExportedBean(defaultVisibility=999)
    public static class Item
    implements ChangeLogSet.AffectedFile {
        private String path;
        private String action;
        private ChangeSet parent;

        public Item() {
            this("", "");
        }

        public Item(String path, String action) {
            this.path = path;
            this.action = action;
        }

        public ChangeSet getParent() {
            return this.parent;
        }

        void setParent(ChangeSet parent) {
            this.parent = parent;
        }

        @Exported
        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        @Exported
        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        @Exported
        public EditType getEditType() {
            if (this.action.equalsIgnoreCase("delete")) {
                return EditType.DELETE;
            }
            if (this.action.equalsIgnoreCase("add")) {
                return EditType.ADD;
            }
            return EditType.EDIT;
        }
    }
}

