/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.teamfoundation.sourcecontrol.webapi.model.GitPush;
import hudson.model.Action;
import hudson.model.BuildableItem;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Executor;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.SimpleParameterDefinition;
import hudson.model.queue.ScheduleResult;
import hudson.plugins.tfs.CommitParameterAction;
import hudson.plugins.tfs.PullRequestParameterAction;
import hudson.plugins.tfs.TeamBuildDetailsAction;
import hudson.plugins.tfs.TeamGlobalStatusAction;
import hudson.plugins.tfs.TeamPullRequestMergedDetailsAction;
import hudson.plugins.tfs.UnsupportedIntegrationAction;
import hudson.plugins.tfs.model.AbstractCommand;
import hudson.plugins.tfs.model.GitCodePushedEventArgs;
import hudson.plugins.tfs.model.GitPullRequestEx;
import hudson.plugins.tfs.model.GitPullRequestMergedEvent;
import hudson.plugins.tfs.model.GitPushEvent;
import hudson.plugins.tfs.model.PullRequestMergeCommitCreatedEventArgs;
import hudson.plugins.tfs.model.TeamBuildPayload;
import hudson.plugins.tfs.model.servicehooks.Event;
import hudson.plugins.tfs.util.ActionHelper;
import hudson.plugins.tfs.util.MediaType;
import hudson.util.RunList;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.util.TimeDuration;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest;

public class BuildCommand
extends AbstractCommand {
    private static final Logger LOGGER = Logger.getLogger(BuildCommand.class.getName());
    private static final String BUILD_REPOSITORY_PROVIDER = "Build.Repository.Provider";
    private static final String BUILD_REPOSITORY_URI = "Build.Repository.Uri";
    private static final String BUILD_REPOSITORY_NAME = "Build.Repository.Name";
    private static final String SYSTEM_TEAM_PROJECT = "System.TeamProject";
    private static final String BUILD_SOURCE_VERSION = "Build.SourceVersion";
    private static final String BUILD_REQUESTED_FOR = "Build.RequestedFor";
    private static final String SYSTEM_TEAM_FOUNDATION_COLLECTION_URI = "System.TeamFoundationCollectionUri";
    private static final String COMMIT_ID = "commitId";
    private static final String PULL_REQUEST_ID = "pullRequestId";
    private static final String UNSUPPORTED_TEMPLATE = "The rich integration with TFS/Team Services is not supported. Reason: %s";

    public static String formatUnsupportedReason(String reason) {
        return String.format(UNSUPPORTED_TEMPLATE, reason);
    }

    protected JSONObject innerPerform(Job job, BuildableItem buildableItem, TimeDuration delay, List<Action> extraActions) {
        JSONObject result = new JSONObject();
        Jenkins jenkins = Jenkins.getActiveInstance();
        Queue queue = jenkins.getQueue();
        Cause.UserIdCause cause = new Cause.UserIdCause();
        CauseAction causeAction = new CauseAction((Cause)cause);
        Action[] actionArray = ActionHelper.create(extraActions, new Action[]{causeAction});
        for (Action a : extraActions) {
            if (!(a instanceof TeamPullRequestMergedDetailsAction)) continue;
            this.cancelPreviousPullRequestBuilds(job, (TeamPullRequestMergedDetailsAction)a, queue);
        }
        ScheduleResult scheduleResult = queue.schedule2((Queue.Task)buildableItem, delay.getTime(), actionArray);
        Queue.Item item = scheduleResult.getItem();
        if (item != null) {
            result.put("created", (Object)(jenkins.getRootUrl() + item.getUrl()));
        }
        return result;
    }

    @Override
    public JSONObject perform(Job<?, ?> job, BuildableItem buildableItem, StaplerRequest req, JSONObject requestPayload, ObjectMapper mapper, TeamBuildPayload teamBuildPayload, TimeDuration delay) {
        String commitId = null;
        String pullRequestId = null;
        ArrayList<Action> actions = new ArrayList<Action>();
        if (teamBuildPayload.BuildVariables != null) {
            BuildCommand.contributeTeamBuildParameterActions(teamBuildPayload.BuildVariables, actions);
        } else if (teamBuildPayload.ServiceHookEvent != null) {
            CommitParameterAction action;
            Iterator args;
            Event event = teamBuildPayload.ServiceHookEvent;
            String eventType = event.getEventType();
            Object resource = event.getResource();
            if ("git.push".equals(eventType)) {
                GitPush gitPush = (GitPush)mapper.convertValue(resource, GitPush.class);
                args = GitPushEvent.decodeGitPush(gitPush, event);
                action = new CommitParameterAction((GitCodePushedEventArgs)((Object)args));
                actions.add((Action)action);
                TeamGlobalStatusAction.addIfApplicable(actions);
            } else if ("git.pullrequest.merged".equals(eventType)) {
                GitPullRequestEx gitPullRequest = (GitPullRequestEx)((Object)mapper.convertValue(resource, GitPullRequestEx.class));
                args = GitPullRequestMergedEvent.decodeGitPullRequest(gitPullRequest, event);
                commitId = ((PullRequestMergeCommitCreatedEventArgs)((Object)args)).commit;
                pullRequestId = Integer.toString(((PullRequestMergeCommitCreatedEventArgs)((Object)args)).pullRequestId, 10);
                action = new PullRequestParameterAction((PullRequestMergeCommitCreatedEventArgs)((Object)args));
                actions.add((Action)action);
                String message = event.getMessage().getText();
                String detailedMessage = event.getDetailedMessage().getText();
                TeamPullRequestMergedDetailsAction teamPullRequestMergedDetailsAction = new TeamPullRequestMergedDetailsAction(gitPullRequest, message, detailedMessage, ((PullRequestMergeCommitCreatedEventArgs)((Object)args)).collectionUri.toString());
                actions.add(teamPullRequestMergedDetailsAction);
                TeamGlobalStatusAction.addIfApplicable(actions);
            }
        }
        ParametersDefinitionProperty pp = (ParametersDefinitionProperty)job.getProperty(ParametersDefinitionProperty.class);
        if (pp != null && requestPayload.containsKey((Object)"parameter")) {
            ParameterValue parameterValue;
            SimpleParameterDefinition spd;
            ParameterDefinition d;
            ArrayList<ParameterValue> values = new ArrayList<ParameterValue>();
            JSONArray a = requestPayload.getJSONArray("parameter");
            ArrayList<String> parameterNames = new ArrayList<String>();
            for (Object o : a) {
                ParameterValue parameterValue2;
                SimpleParameterDefinition spd2;
                JSONObject jo = (JSONObject)o;
                String name = jo.getString("name");
                parameterNames.add(name);
                ParameterDefinition d2 = pp.getParameterDefinition(name);
                if (d2 == null) {
                    throw new IllegalArgumentException("No such parameter definition: " + name);
                }
                if (name.equals(COMMIT_ID) && commitId != null && d2 instanceof SimpleParameterDefinition) {
                    spd2 = (SimpleParameterDefinition)d2;
                    parameterValue2 = spd2.createValue(commitId);
                    commitId = null;
                } else if (name.equals(PULL_REQUEST_ID) && pullRequestId != null && d2 instanceof SimpleParameterDefinition) {
                    spd2 = (SimpleParameterDefinition)d2;
                    parameterValue2 = spd2.createValue(pullRequestId);
                    pullRequestId = null;
                } else {
                    parameterValue2 = d2.createValue(req, jo);
                }
                if (parameterValue2 != null) {
                    values.add(parameterValue2);
                    continue;
                }
                throw new IllegalArgumentException("Cannot retrieve the parameter value: " + name);
            }
            for (ParameterDefinition paramDef : pp.getParameterDefinitions()) {
                if (parameterNames.contains(paramDef.getName()) || !(paramDef instanceof SimpleParameterDefinition)) continue;
                values.add(paramDef.getDefaultParameterValue());
            }
            if (commitId != null && (d = pp.getParameterDefinition(COMMIT_ID)) != null && d instanceof SimpleParameterDefinition) {
                spd = (SimpleParameterDefinition)d;
                parameterValue = spd.createValue(commitId);
                values.add(parameterValue);
            }
            if (pullRequestId != null && (d = pp.getParameterDefinition(PULL_REQUEST_ID)) != null && d instanceof SimpleParameterDefinition) {
                spd = (SimpleParameterDefinition)d;
                parameterValue = spd.createValue(pullRequestId);
                values.add(parameterValue);
            }
            ParametersAction action = new ParametersAction(values);
            actions.add((Action)action);
        }
        return this.innerPerform(job, buildableItem, delay, actions);
    }

    private void cancelPreviousPullRequestBuilds(Job job, TeamPullRequestMergedDetailsAction pullReqeuestMergedDetails, Queue queue) {
        RunList allBuilds = job.getBuilds();
        for (Run run : allBuilds) {
            Queue.Item item;
            TeamPullRequestMergedDetailsAction cause = (TeamPullRequestMergedDetailsAction)run.getAction(TeamPullRequestMergedDetailsAction.class);
            if (cause == null || !run.isBuilding() || !(cause instanceof TeamPullRequestMergedDetailsAction) || cause.gitPullRequest.getPullRequestId() != pullReqeuestMergedDetails.gitPullRequest.getPullRequestId()) continue;
            LOGGER.info("Canceling previously triggered Job: " + run.getFullDisplayName());
            Executor executor = run.getExecutor();
            if (executor != null) {
                executor.doStop();
            }
            if ((item = queue.getItem(run.getQueueId())) == null) continue;
            queue.cancel(item);
        }
    }

    static void contributeTeamBuildParameterActions(Map<String, String> teamBuildParameters, List<Action> actions) {
        TeamBuildDetailsAction teamBuildDetails = new TeamBuildDetailsAction(teamBuildParameters);
        actions.add(teamBuildDetails);
        if (teamBuildParameters.containsKey(BUILD_REPOSITORY_PROVIDER)) {
            boolean isTeamGit;
            String provider = teamBuildParameters.get(BUILD_REPOSITORY_PROVIDER);
            boolean bl = isTeamGit = "TfGit".equalsIgnoreCase(provider) || "TfsGit".equalsIgnoreCase(provider);
            if (isTeamGit) {
                String repoUriString = teamBuildParameters.get(BUILD_REPOSITORY_URI);
                if (StringUtils.isNotBlank((String)repoUriString)) {
                    URI repoUri = URI.create(repoUriString);
                    String collectionUriString = teamBuildParameters.get(SYSTEM_TEAM_FOUNDATION_COLLECTION_URI);
                    URI collectionUri = URI.create(collectionUriString);
                    String projectId = teamBuildParameters.get(SYSTEM_TEAM_PROJECT);
                    String repoId = teamBuildParameters.get(BUILD_REPOSITORY_NAME);
                    String commit = teamBuildParameters.get(BUILD_SOURCE_VERSION);
                    String pushedBy = teamBuildParameters.get(BUILD_REQUESTED_FOR);
                    GitCodePushedEventArgs args = new GitCodePushedEventArgs();
                    args.collectionUri = collectionUri;
                    args.repoUri = repoUri;
                    args.projectId = projectId;
                    args.repoId = repoId;
                    args.commit = commit;
                    args.pushedBy = pushedBy;
                    CommitParameterAction action = new CommitParameterAction(args);
                    actions.add((Action)action);
                }
                UnsupportedIntegrationAction.addToBuild(actions, "Posting build status is not supported for builds triggered by the 'Jenkins Queue Job' task.");
            } else {
                String reason = String.format("The '%s' build variable has a value of '%s', which is not supported.", BUILD_REPOSITORY_PROVIDER, provider);
                UnsupportedIntegrationAction.addToBuild(actions, reason);
                LOGGER.warning(BuildCommand.formatUnsupportedReason(reason));
            }
        } else {
            String reason = String.format("There was no value provided for the '%s' build variable.", BUILD_REPOSITORY_PROVIDER);
            UnsupportedIntegrationAction.addToBuild(actions, reason);
            LOGGER.warning(BuildCommand.formatUnsupportedReason(reason));
        }
    }

    public static class Factory
    implements AbstractCommand.Factory {
        @Override
        public AbstractCommand create() {
            return new BuildCommand();
        }

        @Override
        public String getSampleRequestPayload() {
            Class<?> me = this.getClass();
            InputStream stream = me.getResourceAsStream("BuildCommand.json");
            try {
                String string = IOUtils.toString((InputStream)stream, (Charset)MediaType.UTF_8);
                return string;
            }
            catch (IOException e) {
                throw new Error(e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
    }
}

