/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.StringParameterValue;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.GitStatus;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.git.extensions.impl.IgnoreNotifyCommit;
import hudson.plugins.tfs.SafeParametersAction;
import hudson.plugins.tfs.TeamEventsEndpoint;
import hudson.plugins.tfs.TeamGlobalStatusAction;
import hudson.plugins.tfs.TeamHookCause;
import hudson.plugins.tfs.TeamPRPushTrigger;
import hudson.plugins.tfs.TeamPluginGlobalConfig;
import hudson.plugins.tfs.TeamPushTrigger;
import hudson.plugins.tfs.model.GitCodePushedEventArgs;
import hudson.plugins.tfs.model.PullRequestMergeCommitCreatedEventArgs;
import hudson.plugins.tfs.model.servicehooks.Event;
import hudson.plugins.tfs.util.ActionHelper;
import hudson.plugins.tfs.util.TeamStatus;
import hudson.plugins.tfs.util.UriHelper;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.triggers.SCMTrigger;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.triggers.SCMTriggerItem;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.workflow.cps.CpsScmFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;

public abstract class AbstractHookEvent {
    private static final Logger LOGGER = Logger.getLogger(AbstractHookEvent.class.getName());
    private static final String TRIGGER_ANY_BRANCH = "**";

    public abstract JSONObject perform(ObjectMapper var1, Event var2, String var3, String var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JSONObject fromResponseContributors(List<GitStatus.ResponseContributor> contributors) {
        JSONObject result = new JSONObject();
        JSONArray messages = new JSONArray();
        for (GitStatus.ResponseContributor contributor : contributors) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            try {
                contributor.writeBody(printWriter);
                printWriter.flush();
            }
            finally {
                IOUtils.closeQuietly((Writer)printWriter);
            }
            String contributorMessage = stringWriter.toString();
            messages.add((Object)contributorMessage);
        }
        result.put("messages", (Object)messages);
        return result;
    }

    GitStatus.ResponseContributor triggerJob(GitCodePushedEventArgs gitCodePushedEventArgs, List<Action> actions, boolean bypassPolling, Item project, SCMTriggerItem scmTriggerItem, Boolean repoMatches, Boolean branchMatches) {
        if (!(project instanceof AbstractProject && ((AbstractProject)project).isDisabled() || !(project instanceof Job))) {
            Job job = (Job)project;
            int quietPeriod = scmTriggerItem.getQuietPeriod();
            String targetUrl = job.getAbsoluteUrl() + job.getNextBuildNumber();
            ArrayList<ParameterValue> values = this.getDefaultParameters(job);
            String vstsRefspec = this.getVstsRefspec(gitCodePushedEventArgs);
            values.add((ParameterValue)new StringParameterValue("vstsRefspec", vstsRefspec));
            values.add((ParameterValue)new StringParameterValue("vstsBranchOrCommit", gitCodePushedEventArgs.commit));
            SafeParametersAction paraAction = new SafeParametersAction(values);
            Action[] actionsNew = ActionHelper.create(actions, new Action[]{paraAction});
            ArrayList<Action> actionsWithSafeParams = new ArrayList<Action>(Arrays.asList(actionsNew));
            TeamPluginGlobalConfig config = TeamPluginGlobalConfig.get();
            SCMTrigger scmTrigger = TeamEventsEndpoint.findTrigger(job, SCMTrigger.class);
            if (config.isEnableTeamPushTriggerForAllJobs() && (scmTrigger == null || !scmTrigger.isIgnorePostCommitHooks())) {
                TeamPushTrigger trigger = new TeamPushTrigger(job);
                trigger.execute(gitCodePushedEventArgs, actionsWithSafeParams, bypassPolling);
                if (bypassPolling) {
                    return new TeamEventsEndpoint.ScheduledResponseContributor(project);
                }
                return new TeamEventsEndpoint.PollingScheduledResponseContributor(project);
            }
            if (scmTrigger != null && !scmTrigger.isIgnorePostCommitHooks()) {
                TeamHookCause cause = new TeamHookCause(gitCodePushedEventArgs.commit);
                CauseAction causeAction = new CauseAction((Cause)cause);
                Action[] actionArray = ActionHelper.create(actionsWithSafeParams, new Action[]{causeAction});
                scmTriggerItem.scheduleBuild2(quietPeriod, actionArray);
                if (gitCodePushedEventArgs instanceof PullRequestMergeCommitCreatedEventArgs) {
                    try {
                        TeamStatus.createFromJob((PullRequestMergeCommitCreatedEventArgs)gitCodePushedEventArgs, job);
                    }
                    catch (IOException ex) {
                        LOGGER.warning("Could not create TeamStatus: " + ex.toString());
                    }
                }
                return new TeamEventsEndpoint.ScheduledResponseContributor(project);
            }
            if ((repoMatches.booleanValue() || this.repoMatches(gitCodePushedEventArgs, job).booleanValue()) && (branchMatches.booleanValue() || this.branchMatches(gitCodePushedEventArgs, job).booleanValue())) {
                TeamPushTrigger pushTrigger = null;
                if (gitCodePushedEventArgs instanceof PullRequestMergeCommitCreatedEventArgs) {
                    pushTrigger = TeamEventsEndpoint.findTrigger(job, TeamPRPushTrigger.class);
                } else {
                    List<TeamPushTrigger> listTriggers = TeamEventsEndpoint.findTriggers(job, TeamPushTrigger.class);
                    if (!listTriggers.isEmpty()) {
                        for (TeamPushTrigger trigger : listTriggers) {
                            if (trigger instanceof TeamPRPushTrigger) continue;
                            pushTrigger = trigger;
                            break;
                        }
                    }
                }
                if (pushTrigger != null) {
                    pushTrigger.execute(gitCodePushedEventArgs, actionsWithSafeParams, bypassPolling);
                    if (bypassPolling) {
                        return new TeamEventsEndpoint.ScheduledResponseContributor(project);
                    }
                    return new TeamEventsEndpoint.PollingScheduledResponseContributor(project);
                }
            }
        }
        return null;
    }

    private Boolean repoMatches(GitCodePushedEventArgs gitCodePushedEventArgs, Job job) {
        SCM jobSCM;
        FlowDefinition jobDef;
        if (job instanceof WorkflowJob && (jobDef = ((WorkflowJob)job).getDefinition()) instanceof CpsScmFlowDefinition && (jobSCM = ((CpsScmFlowDefinition)jobDef).getScm()) instanceof GitSCM) {
            GitSCM gitJobSCM = (GitSCM)jobSCM;
            URIish uri = gitCodePushedEventArgs.getRepoURIish();
            for (UserRemoteConfig remoteConfig : gitJobSCM.getUserRemoteConfigs()) {
                String jobRepoUrl = remoteConfig.getUrl();
                if (!StringUtils.equalsIgnoreCase((String)jobRepoUrl, (String)uri.toString())) continue;
                return true;
            }
        }
        return false;
    }

    private Boolean branchMatches(GitCodePushedEventArgs gitCodePushedEventArgs, Job job) {
        block4: {
            SCM jobSCM;
            FlowDefinition jobDef;
            block3: {
                String[] branches;
                String targetBranches;
                if (!(gitCodePushedEventArgs instanceof PullRequestMergeCommitCreatedEventArgs)) break block3;
                TeamPRPushTrigger pushTrigger = TeamEventsEndpoint.findTrigger(job, TeamPRPushTrigger.class);
                if (pushTrigger == null || (targetBranches = pushTrigger.getTargetBranches()) == null || (branches = targetBranches.split(" ")) == null) break block4;
                for (String branchFullName : branches) {
                    String[] items = branchFullName.split("/");
                    if (!StringUtils.equalsIgnoreCase((String)items[items.length - 1], (String)gitCodePushedEventArgs.targetBranch)) continue;
                    return true;
                }
                break block4;
            }
            if (job instanceof WorkflowJob && (jobDef = ((WorkflowJob)job).getDefinition()) instanceof CpsScmFlowDefinition && (jobSCM = ((CpsScmFlowDefinition)jobDef).getScm()) instanceof GitSCM) {
                GitSCM gitJobSCM = (GitSCM)jobSCM;
                for (BranchSpec branchFullName : gitJobSCM.getBranches()) {
                    String[] items = branchFullName.getName().split("/");
                    if (!StringUtils.equalsIgnoreCase((String)items[items.length - 1], (String)gitCodePushedEventArgs.targetBranch)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<GitStatus.ResponseContributor> pollOrQueueFromEvent(GitCodePushedEventArgs gitCodePushedEventArgs, List<Action> actions, boolean bypassPolling) {
        ArrayList<GitStatus.ResponseContributor> result = new ArrayList<GitStatus.ResponseContributor>();
        String commit = gitCodePushedEventArgs.commit;
        if (commit == null) {
            result.add((GitStatus.ResponseContributor)new GitStatus.MessageResponseContributor("No commits were pushed, skipping further event processing."));
            return result;
        }
        URIish uri = gitCodePushedEventArgs.getRepoURIish();
        TeamGlobalStatusAction.addIfApplicable(actions);
        SecurityContext old = ACL.impersonate((Authentication)ACL.SYSTEM);
        try {
            boolean scmFound = false;
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins == null) {
                LOGGER.severe("Jenkins.getInstance() is null");
                ArrayList<GitStatus.ResponseContributor> arrayList = result;
                return arrayList;
            }
            int totalBranchMatches = 0;
            for (Item project : Jenkins.getActiveInstance().getAllItems()) {
                SCMTriggerItem scmTriggerItem = SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem((Item)project);
                if (scmTriggerItem == null || scmTriggerItem.getSCMs() == null) continue;
                if (scmTriggerItem.getSCMs().isEmpty()) {
                    GitStatus.ResponseContributor triggerResult = this.triggerJob(gitCodePushedEventArgs, actions, bypassPolling, project, scmTriggerItem, false, false);
                    if (triggerResult == null) continue;
                    result.add(triggerResult);
                    continue;
                }
                block5: for (SCM scm : scmTriggerItem.getSCMs()) {
                    if (!(scm instanceof GitSCM)) continue;
                    GitSCM git = (GitSCM)scm;
                    scmFound = true;
                    for (RemoteConfig repository : git.getRepositories()) {
                        GitStatus.ResponseContributor triggerResult;
                        Object remoteURL2;
                        boolean repositoryMatches = false;
                        for (Object remoteURL2 : repository.getURIs()) {
                            if (!UriHelper.areSameGitRepo(uri, (URIish)remoteURL2)) continue;
                            repositoryMatches = true;
                            break;
                        }
                        if (repositoryMatches && gitCodePushedEventArgs instanceof PullRequestMergeCommitCreatedEventArgs) {
                            GitStatus.ResponseContributor triggerResult2 = this.triggerJob(gitCodePushedEventArgs, actions, bypassPolling, project, scmTriggerItem, true, false);
                            if (triggerResult2 == null) continue block5;
                            result.add(triggerResult2);
                            continue block5;
                        }
                        boolean branchMatches = false;
                        remoteURL2 = git.getBranches().iterator();
                        while (remoteURL2.hasNext()) {
                            BranchSpec branch = (BranchSpec)remoteURL2.next();
                            String branchString = branch.toString();
                            String[] items = branchString.split("/");
                            String branchName = items[items.length - 1];
                            if (!branchName.equalsIgnoreCase(TRIGGER_ANY_BRANCH) && !branchName.equalsIgnoreCase(gitCodePushedEventArgs.targetBranch)) continue;
                            branchMatches = true;
                            ++totalBranchMatches;
                            break;
                        }
                        if (!repositoryMatches || !branchMatches || git.getExtensions().get(IgnoreNotifyCommit.class) != null || (triggerResult = this.triggerJob(gitCodePushedEventArgs, actions, bypassPolling, project, scmTriggerItem, true, true)) == null) continue;
                        result.add(triggerResult);
                        continue block5;
                    }
                }
            }
            if (!scmFound) {
                result.add((GitStatus.ResponseContributor)new GitStatus.MessageResponseContributor("No Git jobs found"));
            } else if (totalBranchMatches == 0) {
                String template = "No Git jobs matched the remote URL '%s' requested by an event.";
                String message = String.format("No Git jobs matched the remote URL '%s' requested by an event.", uri);
                LOGGER.warning(message);
            }
            ArrayList<GitStatus.ResponseContributor> arrayList = result;
            return arrayList;
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)old);
        }
    }

    private ArrayList<ParameterValue> getDefaultParameters(Job<?, ?> job) {
        ArrayList<ParameterValue> values = new ArrayList<ParameterValue>();
        ParametersDefinitionProperty pdp = (ParametersDefinitionProperty)job.getProperty(ParametersDefinitionProperty.class);
        if (pdp != null) {
            for (ParameterDefinition pd : pdp.getParameterDefinitions()) {
                if (pd.getName().equals("sha1")) continue;
                values.add(pd.getDefaultParameterValue());
            }
        }
        return values;
    }

    private String getVstsRefspec(GitCodePushedEventArgs gitCodePushedEventArgs) {
        if (gitCodePushedEventArgs instanceof PullRequestMergeCommitCreatedEventArgs) {
            int prId = ((PullRequestMergeCommitCreatedEventArgs)gitCodePushedEventArgs).pullRequestId;
            return String.format("+refs/pull/%d/merge:refs/remotes/pull/%d/merge", prId, prId);
        }
        return "+refs/heads/*:refs/remotes/origin/*";
    }

    public static interface Factory {
        public AbstractHookEvent create();

        public String getSampleRequestPayload();
    }
}

