/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.commands;

import com.google.common.base.Strings;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Changeset;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.DateVersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.LabelVersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.VersionSpec;
import hudson.model.TaskListener;
import hudson.plugins.tfs.commands.AbstractCallableCommand;
import hudson.plugins.tfs.commands.ServerConfigurationProvider;
import hudson.plugins.tfs.model.MockableVersionControlClient;
import hudson.plugins.tfs.model.Server;
import hudson.plugins.tfs.util.DateUtil;
import hudson.plugins.tfs.util.TextTableParser;
import hudson.remoting.Callable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class RemoteChangesetVersionCommand
extends AbstractCallableCommand<Integer, Exception> {
    private static final String QueryingTemplate = "Querying for remote changeset at '%s' as of '%s'...";
    private static final String ResultTemplate = "Query result is: Changeset #%d by '%s' on '%s'.";
    private static final String FailedTemplate = "Query returned no result!";
    private final String versionSpecString;
    private final String path;

    public RemoteChangesetVersionCommand(ServerConfigurationProvider server, String remotePath, VersionSpec versionSpec) {
        super(server);
        this.path = remotePath;
        this.versionSpecString = RemoteChangesetVersionCommand.toString(versionSpec);
    }

    @Override
    public Callable<Integer, Exception> getCallable() {
        return this;
    }

    public Integer call() throws Exception {
        String resultMessage;
        Server server = this.createServer();
        MockableVersionControlClient vcc = server.getVersionControlClient();
        TaskListener listener = server.getListener();
        PrintStream logger = listener.getLogger();
        VersionSpec versionSpec = VersionSpec.parseSingleVersionFromSpec((String)this.versionSpecString, (String)".");
        String specString = RemoteChangesetVersionCommand.toString(versionSpec);
        String queryingMessage = String.format(QueryingTemplate, this.path, specString);
        logger.println(queryingMessage);
        Changeset[] serverChangeSets = vcc.queryHistory(this.path, versionSpec, 0, RecursionType.FULL, null, null, null, 1, false, true, false, false);
        Integer changeSetNumber = null;
        if (serverChangeSets != null && serverChangeSets.length >= 1) {
            Changeset serverChangeset = serverChangeSets[0];
            changeSetNumber = serverChangeset.getChangesetID();
            Date changeSetDate = serverChangeset.getDate().getTime();
            String author = serverChangeset.getOwner();
            SimpleDateFormat simpleDateFormat = DateUtil.TFS_DATETIME_FORMATTER.get();
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            String changeSetDateIso8601 = simpleDateFormat.format(changeSetDate);
            resultMessage = String.format(ResultTemplate, changeSetNumber, author, changeSetDateIso8601);
        } else {
            resultMessage = FailedTemplate;
        }
        logger.println(resultMessage);
        return changeSetNumber;
    }

    public static String toString(VersionSpec versionSpec) {
        if (versionSpec instanceof DateVersionSpec) {
            DateVersionSpec dateVersionSpec = (DateVersionSpec)versionSpec;
            return DateUtil.toString(dateVersionSpec);
        }
        if (versionSpec instanceof LabelVersionSpec) {
            LabelVersionSpec labelVersionSpec = (LabelVersionSpec)versionSpec;
            String label = labelVersionSpec.getLabel();
            String scope = labelVersionSpec.getScope();
            StringBuilder sb = new StringBuilder(1 + label.length() + Strings.nullToEmpty((String)scope).length());
            sb.append('L');
            sb.append(label);
            if (!Strings.isNullOrEmpty((String)scope)) {
                sb.append('@');
                sb.append(scope);
            }
            return sb.toString();
        }
        return versionSpec.toString();
    }

    public String parse(Reader consoleReader) throws ParseException, IOException {
        TextTableParser parser = new TextTableParser(new BufferedReader(consoleReader), 1);
        if (parser.nextRow()) {
            return parser.getColumn(0);
        }
        return "";
    }
}

