/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.commands;

import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspaceLocation;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspaceOptions;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.WorkingFolder;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.WorkingFolderType;
import hudson.model.TaskListener;
import hudson.plugins.tfs.commands.AbstractCallableCommand;
import hudson.plugins.tfs.commands.ServerConfigurationProvider;
import hudson.plugins.tfs.model.MockableVersionControlClient;
import hudson.plugins.tfs.model.Server;
import hudson.remoting.Callable;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;

public class NewWorkspaceCommand
extends AbstractCallableCommand<Void, Exception> {
    private static final WorkingFolder[] EMPTY_WORKING_FOLDER_ARRAY = new WorkingFolder[0];
    private static final String CloakingTemplate = "Cloaking '%s' in workspace '%s'...";
    private static final String CreatingTemplate = "Creating workspace '%s' owned by '%s'...";
    private static final String CreatedTemplate = "Created workspace '%s'.";
    private static final String MappingTemplate = "Mapping '%s' to local folder '%s' in workspace '%s'...";
    private final String workspaceName;
    private final String serverPath;
    private final Collection<String> cloakedPaths;
    private final String localPath;

    public NewWorkspaceCommand(ServerConfigurationProvider server, String workspaceName, String serverPath, Collection<String> cloakedPaths, String localPath) {
        super(server);
        this.workspaceName = workspaceName;
        this.serverPath = serverPath;
        this.cloakedPaths = cloakedPaths;
        this.localPath = localPath;
    }

    @Override
    public Callable<Void, Exception> getCallable() {
        return this;
    }

    public Void call() throws IOException {
        Server server = this.createServer();
        MockableVersionControlClient vcc = server.getVersionControlClient();
        TFSTeamProjectCollection connection = vcc.getConnection();
        TaskListener listener = server.getListener();
        PrintStream logger = listener.getLogger();
        String userName = server.getUserName();
        String creatingMessage = String.format(CreatingTemplate, this.workspaceName, userName);
        logger.println(creatingMessage);
        WorkingFolder[] foldersToMap = null;
        if (this.serverPath != null && this.localPath != null) {
            String mappingMessage = String.format(MappingTemplate, this.serverPath, this.localPath, this.workspaceName);
            logger.println(mappingMessage);
            ArrayList<WorkingFolder> folderList = new ArrayList<WorkingFolder>();
            folderList.add(new WorkingFolder(this.serverPath, LocalPath.canonicalize((String)this.localPath), WorkingFolderType.MAP, RecursionType.FULL));
            for (String cloakedPath : this.cloakedPaths) {
                String cloakingMessage = String.format(CloakingTemplate, cloakedPath, this.workspaceName);
                logger.println(cloakingMessage);
                folderList.add(new WorkingFolder(cloakedPath, null, WorkingFolderType.CLOAK));
            }
            foldersToMap = folderList.toArray(EMPTY_WORKING_FOLDER_ARRAY);
        }
        this.updateCache(connection);
        vcc.createWorkspace(foldersToMap, this.workspaceName, ".", ".", null, WorkspaceLocation.SERVER, WorkspaceOptions.NONE);
        String createdMessage = String.format(CreatedTemplate, this.workspaceName);
        logger.println(createdMessage);
        return null;
    }
}

