/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.commands;

import com.microsoft.tfs.core.clients.versioncontrol.WorkspacePermissions;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.jni.helpers.LocalHost;
import hudson.Util;
import hudson.model.TaskListener;
import hudson.plugins.tfs.commands.AbstractCallableCommand;
import hudson.plugins.tfs.commands.ServerConfigurationProvider;
import hudson.plugins.tfs.model.MockableVersionControlClient;
import hudson.plugins.tfs.model.Server;
import hudson.plugins.tfs.util.TextTableParser;
import hudson.remoting.Callable;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ListWorkspacesCommand
extends AbstractCallableCommand<List<hudson.plugins.tfs.model.Workspace>, Exception> {
    private static final String ListingWorkspacesTemplate = "Downloading list of workspaces from %s...";
    private final String computer;
    private final boolean shouldLogWorkspaces;

    public ListWorkspacesCommand(ServerConfigurationProvider server) {
        this(server, null, false);
    }

    ListWorkspacesCommand(ServerConfigurationProvider server, String computer, boolean shouldLogWorkspaces) {
        super(server);
        this.computer = computer;
        this.shouldLogWorkspaces = shouldLogWorkspaces;
    }

    @Override
    public Callable<List<hudson.plugins.tfs.model.Workspace>, Exception> getCallable() {
        return this;
    }

    public List<hudson.plugins.tfs.model.Workspace> call() throws Exception {
        Server server = this.createServer();
        MockableVersionControlClient vcc = server.getVersionControlClient();
        TaskListener listener = server.getListener();
        PrintStream logger = listener.getLogger();
        String computerName = this.computer != null ? this.computer : LocalHost.getShortName();
        String listWorkspacesMessage = String.format(ListingWorkspacesTemplate, server.getUrl());
        logger.println(listWorkspacesMessage);
        Workspace[] sdkWorkspaces = vcc.queryWorkspaces(null, null, computerName, WorkspacePermissions.NONE_OR_NOT_SUPPORTED);
        ArrayList<hudson.plugins.tfs.model.Workspace> result = new ArrayList<hudson.plugins.tfs.model.Workspace>(sdkWorkspaces.length);
        for (Workspace sdkWorkspace : sdkWorkspaces) {
            String name = sdkWorkspace.getName();
            String computer = sdkWorkspace.getComputer();
            String ownerName = sdkWorkspace.getOwnerName();
            String comment = Util.fixNull((String)sdkWorkspace.getComment());
            hudson.plugins.tfs.model.Workspace workspace = new hudson.plugins.tfs.model.Workspace(name, computer, ownerName, comment);
            result.add(workspace);
        }
        if (this.shouldLogWorkspaces) {
            ListWorkspacesCommand.log(result, logger);
        }
        return result;
    }

    public List<hudson.plugins.tfs.model.Workspace> parse(Reader consoleReader) throws IOException {
        ArrayList<hudson.plugins.tfs.model.Workspace> list = new ArrayList<hudson.plugins.tfs.model.Workspace>();
        TextTableParser parser = new TextTableParser(consoleReader, 1);
        while (parser.nextRow()) {
            hudson.plugins.tfs.model.Workspace workspace = new hudson.plugins.tfs.model.Workspace(parser.getColumn(0), parser.getColumn(2), parser.getColumn(1), Util.fixNull((String)parser.getColumn(3)));
            list.add(workspace);
        }
        return list;
    }

    static void log(List<hudson.plugins.tfs.model.Workspace> workspaces, PrintStream logger) {
        int maxName = "Workspace".length();
        int maxOwner = "Owner".length();
        int maxComputer = "Computer".length();
        int maxComment = "Comment".length();
        for (hudson.plugins.tfs.model.Workspace workspace : workspaces) {
            String name = workspace.getName();
            maxName = Math.max(maxName, name.length());
            String ownerName = workspace.getOwner();
            maxOwner = Math.max(maxOwner, ownerName.length());
            String computer = workspace.getComputer();
            maxComputer = Math.max(maxComputer, computer.length());
            String comment = workspace.getComment();
            maxComment = Math.max(maxComment, comment.length());
        }
        String template = "%1$-" + maxName + "s %2$-" + maxOwner + "s %3$-" + maxComputer + "s %4$-" + maxComment + "s";
        String header = String.format(template, "Workspace", "Owner", "Computer", "Comment");
        logger.println(header);
        String divider = String.format(template, StringUtils.repeat((String)"-", (int)maxName), StringUtils.repeat((String)"-", (int)maxOwner), StringUtils.repeat((String)"-", (int)maxComputer), StringUtils.repeat((String)"-", (int)maxComment));
        logger.println(divider);
        for (hudson.plugins.tfs.model.Workspace workspace : workspaces) {
            String name = workspace.getName();
            String ownerName = workspace.getOwner();
            String computer = workspace.getComputer();
            String comment = workspace.getComment();
            String line = String.format(template, name, ownerName, computer, comment);
            logger.println(line);
        }
    }

    public static interface WorkspaceFactory {
        public hudson.plugins.tfs.model.Workspace createWorkspace(String var1, String var2, String var3, String var4);
    }
}

