/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.commands;

import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LabelChildOption;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LabelResult;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.VersionControlLabel;
import com.microsoft.tfs.core.clients.versioncontrol.specs.ItemSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.LabelItemSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.VersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.WorkspaceVersionSpec;
import hudson.model.TaskListener;
import hudson.plugins.tfs.commands.AbstractCallableCommand;
import hudson.plugins.tfs.commands.ServerConfigurationProvider;
import hudson.plugins.tfs.model.MockableVersionControlClient;
import hudson.plugins.tfs.model.Server;
import hudson.remoting.Callable;
import java.io.PrintStream;

public class LabelCommand
extends AbstractCallableCommand<Void, Exception> {
    private static final String CreatingTemplate = "Creating label '%s' on '%s' as of the current version in workspace '%s'...";
    private static final String CreatedTemplate = "Created label '%s'.";
    private final String labelName;
    private final String workspaceName;
    private final String projectPath;

    public LabelCommand(ServerConfigurationProvider configurationProvider, String labelName, String workspaceName, String projectPath) {
        super(configurationProvider);
        this.labelName = labelName;
        this.workspaceName = workspaceName;
        this.projectPath = projectPath;
    }

    private String getLabelComment() {
        return "Automatically_applied_by_Jenkins_TFS_plugin";
    }

    @Override
    public Callable<Void, Exception> getCallable() {
        return this;
    }

    public Void call() throws Exception {
        Server server = this.createServer();
        MockableVersionControlClient vcc = server.getVersionControlClient();
        TaskListener listener = server.getListener();
        PrintStream logger = listener.getLogger();
        String userName = ".";
        String creatingMessage = String.format(CreatingTemplate, this.labelName, this.projectPath, this.workspaceName);
        logger.println(creatingMessage);
        VersionControlLabel versionControlLabel = new VersionControlLabel(this.labelName, ".", ".", null, this.getLabelComment());
        ItemSpec itemSpec = new ItemSpec(this.projectPath, RecursionType.FULL);
        WorkspaceVersionSpec workspaceVersionSpec = new WorkspaceVersionSpec(this.workspaceName, ".", ".");
        LabelItemSpec labelItemSpec = new LabelItemSpec(itemSpec, (VersionSpec)workspaceVersionSpec, false);
        LabelItemSpec[] items = new LabelItemSpec[]{labelItemSpec};
        LabelResult[] labelResults = vcc.createLabel(versionControlLabel, items, LabelChildOption.FAIL);
        if (labelResults == null || labelResults.length == 0) {
            throw new RuntimeException("Label creation failed.");
        }
        String createdMessage = String.format(CreatedTemplate, this.labelName);
        logger.println(createdMessage);
        return null;
    }
}

