/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.commands;

import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import hudson.model.TaskListener;
import hudson.plugins.tfs.commands.AbstractCallableCommand;
import hudson.plugins.tfs.commands.ServerConfigurationProvider;
import hudson.plugins.tfs.model.MockableVersionControlClient;
import hudson.plugins.tfs.model.Server;
import hudson.remoting.Callable;
import java.io.PrintStream;

public class GetWorkspaceMappingCommand
extends AbstractCallableCommand<String, Exception> {
    private static final String CheckingMappingTemplate = "Checking if there exists a mapping for %s...";
    private static final String FoundResultTemplate = "yes, in workspace '%s'.";
    private final String localPath;

    public GetWorkspaceMappingCommand(ServerConfigurationProvider serverConfig, String localPath) {
        super(serverConfig);
        this.localPath = localPath;
    }

    @Override
    public Callable<String, Exception> getCallable() {
        return this;
    }

    public String call() throws Exception {
        Server server = this.createServer();
        MockableVersionControlClient vcc = server.getVersionControlClient();
        TFSTeamProjectCollection connection = vcc.getConnection();
        this.updateCache(connection);
        TaskListener listener = server.getListener();
        PrintStream logger = listener.getLogger();
        String checkingMessage = String.format(CheckingMappingTemplate, this.localPath);
        logger.print(checkingMessage);
        Workspace workspace = vcc.tryGetWorkspace(this.localPath);
        boolean existsMapping = workspace != null;
        String result = existsMapping ? workspace.getName() : null;
        String resultMessage = existsMapping ? String.format(FoundResultTemplate, result) : "no.";
        logger.println(resultMessage);
        return result;
    }
}

