/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.commands;

import com.microsoft.tfs.core.clients.versioncontrol.GetOptions;
import com.microsoft.tfs.core.clients.versioncontrol.events.GetEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.GetListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.VersionControlEventEngine;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.LatestVersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.VersionSpec;
import hudson.model.TaskListener;
import hudson.plugins.tfs.commands.AbstractCallableCommand;
import hudson.plugins.tfs.commands.RemoteChangesetVersionCommand;
import hudson.plugins.tfs.commands.ServerConfigurationProvider;
import hudson.plugins.tfs.model.MockableVersionControlClient;
import hudson.plugins.tfs.model.Server;
import hudson.remoting.Callable;
import java.io.PrintStream;

public class GetFilesToWorkFolderCommand
extends AbstractCallableCommand<Void, Exception>
implements GetListener {
    private static final String GettingTemplate = "Getting version '%s' to '%s'...";
    private static final String GotTemplate = "Finished getting version '%s'. Retrieved %d resources.";
    private final String workFolder;
    private final String versionSpec;
    private final boolean useOverwrite;
    private final boolean shouldLogEachGet;
    private PrintStream logger;
    private int getCount = 0;

    public GetFilesToWorkFolderCommand(ServerConfigurationProvider server, String workFolder, String versionSpec, boolean useOverwrite) {
        this(server, workFolder, versionSpec, useOverwrite, false);
    }

    public GetFilesToWorkFolderCommand(ServerConfigurationProvider server, String workFolder, String versionSpec, boolean useOverwrite, boolean shouldLogEachGet) {
        super(server);
        this.workFolder = workFolder;
        this.versionSpec = versionSpec;
        this.useOverwrite = useOverwrite;
        this.shouldLogEachGet = shouldLogEachGet;
    }

    @Override
    public Callable<Void, Exception> getCallable() {
        return this;
    }

    void setLogger(PrintStream logger) {
        this.logger = logger;
    }

    public Void call() throws Exception {
        Server server = this.createServer();
        MockableVersionControlClient vcc = server.getVersionControlClient();
        TaskListener listener = server.getListener();
        this.logger = listener.getLogger();
        Object getVersionSpec = this.versionSpec != null ? VersionSpec.parseSingleVersionFromSpec((String)this.versionSpec, null) : LatestVersionSpec.INSTANCE;
        String versionSpecString = RemoteChangesetVersionCommand.toString((VersionSpec)getVersionSpec);
        String gettingMessage = String.format(GettingTemplate, versionSpecString, this.workFolder);
        this.logger.println(gettingMessage);
        Workspace workspace = vcc.getWorkspace(this.workFolder);
        VersionControlEventEngine eventEngine = vcc.getEventEngine();
        eventEngine.addGetListener((GetListener)this);
        workspace.get((VersionSpec)getVersionSpec, this.useOverwrite ? GetOptions.OVERWRITE : GetOptions.NONE);
        eventEngine.removeGetListener((GetListener)this);
        String gotMessage = String.format(GotTemplate, versionSpecString, this.getCount);
        this.logger.println(gotMessage);
        return null;
    }

    public void onGet(GetEvent getEvent) {
        ++this.getCount;
        if (this.shouldLogEachGet) {
            this.logger.println(getEvent.getTargetLocalItem());
        }
    }
}

