/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.commands;

import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspacePermissions;
import com.microsoft.tfs.core.clients.versioncontrol.Workstation;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.clients.versioncontrol.workspacecache.WorkspaceInfo;
import com.microsoft.tfs.core.config.persistence.PersistenceStoreProvider;
import com.microsoft.tfs.jni.helpers.LocalHost;
import hudson.model.TaskListener;
import hudson.plugins.tfs.commands.AbstractCallableCommand;
import hudson.plugins.tfs.commands.ServerConfigurationProvider;
import hudson.plugins.tfs.model.MockableVersionControlClient;
import hudson.plugins.tfs.model.Server;
import hudson.remoting.Callable;
import java.io.IOException;
import java.io.PrintStream;

public class DeleteWorkspaceCommand
extends AbstractCallableCommand<Void, IOException> {
    private static final String DeletingTemplate = "Deleting workspaces named '%s' from computer '%s'...";
    private static final String DeletedTemplate = "Deleted %d workspace(s) named '%s'.";
    private final String workspaceName;
    private final String computerName;

    public DeleteWorkspaceCommand(ServerConfigurationProvider server, String workspaceName) {
        this(server, workspaceName, null);
    }

    public DeleteWorkspaceCommand(ServerConfigurationProvider server, String workspaceName, String computerName) {
        super(server);
        this.workspaceName = workspaceName;
        this.computerName = computerName;
    }

    @Override
    public Callable<Void, IOException> getCallable() {
        return this;
    }

    public Void call() throws IOException {
        Server server = this.createServer();
        MockableVersionControlClient vcc = server.getVersionControlClient();
        TaskListener listener = server.getListener();
        PrintStream logger = listener.getLogger();
        String computerName = this.computerName == null ? LocalHost.getShortName() : this.computerName;
        String deletingMessage = String.format(DeletingTemplate, this.workspaceName, computerName);
        logger.println(deletingMessage);
        WorkspacePermissions filter = WorkspacePermissions.NONE_OR_NOT_SUPPORTED;
        Workspace[] workspaces = vcc.queryWorkspaces(this.workspaceName, null, computerName, filter);
        int numDeletions = 0;
        for (Workspace innerWorkspace : workspaces) {
            vcc.deleteWorkspace(innerWorkspace);
            WorkspaceInfo workspaceInfo = vcc.removeCachedWorkspace(this.workspaceName, ".");
            if (workspaceInfo != null) {
                TFSTeamProjectCollection tpc = vcc.getConnection();
                PersistenceStoreProvider provider = tpc.getPersistenceStoreProvider();
                Workstation currentWorkstation = Workstation.getCurrent((PersistenceStoreProvider)provider);
                currentWorkstation.saveConfigIfDirty();
            }
            ++numDeletions;
        }
        String deletedMessage = String.format(DeletedTemplate, numDeletions, this.workspaceName);
        logger.println(deletedMessage);
        return null;
    }
}

