/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.commands;

import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.versioncontrol.Workstation;
import com.microsoft.tfs.core.config.persistence.PersistenceStoreProvider;
import hudson.model.TaskListener;
import hudson.plugins.tfs.commands.ServerConfigurationProvider;
import hudson.plugins.tfs.model.ExtraSettings;
import hudson.plugins.tfs.model.Server;
import hudson.plugins.tfs.model.WebProxySettings;
import hudson.remoting.Callable;
import java.io.IOException;
import java.io.Serializable;
import jenkins.security.MasterToSlaveCallable;

public abstract class AbstractCallableCommand<V, T extends Throwable>
extends MasterToSlaveCallable<V, T>
implements Serializable {
    private final String url;
    private final String userName;
    private final String userPassword;
    private final TaskListener listener;
    private final WebProxySettings webProxySettings;
    private final ExtraSettings extraSettings;

    protected AbstractCallableCommand(ServerConfigurationProvider serverConfig) {
        this.url = serverConfig.getUrl();
        this.userName = serverConfig.getUserName();
        this.userPassword = serverConfig.getUserPassword();
        this.listener = serverConfig.getListener();
        this.webProxySettings = serverConfig.getWebProxySettings();
        this.extraSettings = serverConfig.getExtraSettings();
    }

    protected void updateCache(TFSTeamProjectCollection connection) {
        PersistenceStoreProvider persistenceStoreProvider = connection.getPersistenceStoreProvider();
        Workstation workstation = Workstation.getCurrent((PersistenceStoreProvider)persistenceStoreProvider);
        VersionControlClient vcc = connection.getVersionControlClient();
        workstation.updateWorkspaceInfoCache(vcc, ".");
    }

    public Server createServer() throws IOException {
        Server server = new Server(null, this.listener, this.url, this.userName, this.userPassword, this.webProxySettings, this.extraSettings);
        return server;
    }

    public abstract <V, E extends Throwable> Callable<V, E> getCallable();
}

