/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.browsers;

import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.plugins.tfs.TeamFoundationServerScm;
import hudson.plugins.tfs.browsers.TeamFoundationServerRepositoryBrowser;
import hudson.plugins.tfs.model.ChangeSet;
import hudson.plugins.tfs.util.QueryString;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SCM;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.kohsuke.stapler.DataBoundConstructor;

public class TeamSystemWebAccessBrowser
extends TeamFoundationServerRepositoryBrowser {
    private static final long serialVersionUID = 1L;
    private final String url;

    @DataBoundConstructor
    public TeamSystemWebAccessBrowser(String urlExample) {
        this.url = Util.fixEmpty((String)urlExample);
    }

    public String getUrl() {
        return this.url;
    }

    private String getServerConfiguration(ChangeSet changeset) {
        AbstractProject project = changeset.getParent().build.getProject();
        SCM scm = project.getScm();
        if (scm instanceof TeamFoundationServerScm) {
            return ((TeamFoundationServerScm)scm).getServerUrl((Run<?, ?>)changeset.getParent().build);
        }
        DescriptorImpl descriptor = (DescriptorImpl)this.getDescriptor();
        String displayName = descriptor.getDisplayName();
        throw new IllegalStateException("'" + displayName + "' repository browser can only be used with the 'Team Foundation Server' SCM");
    }

    private String getBaseUrlString(ChangeSet changeSet) throws MalformedURLException {
        String baseUrl = this.url;
        if (baseUrl == null) {
            baseUrl = this.getServerConfiguration(changeSet);
        }
        baseUrl = TeamSystemWebAccessBrowser.normalizeToEndWithSlash((URL)new URL(baseUrl)).toString();
        return baseUrl;
    }

    public URL getChangeSetLink(ChangeSet changeSet) throws IOException {
        String baseUrlString = this.getBaseUrlString(changeSet);
        URL baseUrl = new URL(baseUrlString);
        return new URL(baseUrl, "_versionControl/changeset/" + changeSet.getVersion());
    }

    private URL createChangeSetItemLink(ChangeSet.Item item, String action) throws IOException {
        ChangeSet changeSet = item.getParent();
        URL changeSetUrl = this.getChangeSetLink(changeSet);
        QueryString qs = new QueryString();
        qs.put("path", item.getPath());
        qs.put("version", changeSet.getVersion());
        qs.put("_a", action);
        return new URL(changeSetUrl, "#" + qs.toString());
    }

    @Override
    public URL getFileLink(ChangeSet.Item item) throws IOException {
        return this.createChangeSetItemLink(item, "contents");
    }

    @Override
    public URL getDiffLink(ChangeSet.Item item) throws IOException {
        if (item.getEditType() != EditType.EDIT) {
            return null;
        }
        return this.createChangeSetItemLink(item, "compare");
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<RepositoryBrowser<?>> {
        public DescriptorImpl() {
            super(TeamSystemWebAccessBrowser.class);
        }

        public String getDisplayName() {
            return "Microsoft Team Foundation Server/Visual Studio Team Services";
        }
    }
}

