/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.actions;

import com.microsoft.tfs.core.clients.versioncontrol.specs.version.DateVersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.VersionSpec;
import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.plugins.tfs.commands.RemoteChangesetVersionCommand;
import hudson.plugins.tfs.model.ChangeSet;
import hudson.plugins.tfs.model.Project;
import hudson.plugins.tfs.model.Server;
import hudson.plugins.tfs.model.Workspace;
import hudson.plugins.tfs.model.Workspaces;
import java.io.IOException;
import java.io.PrintStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class CheckoutAction {
    private final String workspaceName;
    private final String projectPath;
    private final Collection<String> cloakedPaths;
    private final String localFolder;
    private final boolean useUpdate;
    private final boolean useOverwrite;

    public CheckoutAction(String workspaceName, String projectPath, Collection<String> cloakedPaths, String localFolder, boolean useUpdate, boolean useOverwrite) {
        this.workspaceName = workspaceName;
        this.projectPath = projectPath;
        this.cloakedPaths = cloakedPaths;
        this.localFolder = localFolder;
        this.useUpdate = useUpdate;
        this.useOverwrite = useOverwrite;
    }

    public List<ChangeSet> checkout(Server server, FilePath workspacePath, Calendar lastBuildTimestamp, Calendar currentBuildTimestamp) throws IOException, InterruptedException, ParseException {
        DateVersionSpec lastBuildVersionSpec = lastBuildTimestamp != null ? new DateVersionSpec(lastBuildTimestamp) : null;
        DateVersionSpec currentBuildVersionSpec = new DateVersionSpec(currentBuildTimestamp);
        return this.checkout(server, workspacePath, (VersionSpec)lastBuildVersionSpec, (VersionSpec)currentBuildVersionSpec);
    }

    public List<ChangeSet> checkout(Server server, FilePath workspacePath, VersionSpec lastBuildVersionSpec, VersionSpec currentBuildVersionSpec) throws IOException, InterruptedException {
        Project project = this.getProject(server, workspacePath);
        String versionSpecString = RemoteChangesetVersionCommand.toString(currentBuildVersionSpec);
        String normalizedFolder = CheckoutAction.determineCheckoutPath(workspacePath, this.localFolder);
        project.getFiles(normalizedFolder, versionSpecString, this.useOverwrite);
        if (lastBuildVersionSpec != null) {
            return project.getDetailedHistoryWithoutCloakedPaths(lastBuildVersionSpec, currentBuildVersionSpec, this.cloakedPaths);
        }
        return new ArrayList<ChangeSet>();
    }

    public List<ChangeSet> checkoutBySingleVersionSpec(Server server, FilePath workspacePath, String singleVersionSpec) throws IOException, InterruptedException {
        Project project = this.getProject(server, workspacePath);
        String normalizedFolder = CheckoutAction.determineCheckoutPath(workspacePath, this.localFolder);
        project.getFiles(normalizedFolder, singleVersionSpec, this.useOverwrite);
        return project.getDetailedHistory(singleVersionSpec);
    }

    static String determineCheckoutPath(FilePath workspacePath, String localFolder) {
        FilePath combinedPath = new FilePath(workspacePath, localFolder);
        String result = combinedPath.getRemote();
        return result;
    }

    private Project getProject(Server server, FilePath workspacePath) throws IOException, InterruptedException {
        Workspace workspace;
        String message;
        Workspaces workspaces = server.getWorkspaces();
        Project project = server.getProject(this.projectPath);
        FilePath localFolderPath = workspacePath.child(this.localFolder);
        String localPath = localFolderPath.getRemote();
        TaskListener listener = server.getListener();
        PrintStream logger = listener.getLogger();
        HashSet<String> workspaceNamesToDelete = new HashSet<String>();
        String existingWorkspaceName = workspaces.getWorkspaceMapping(localPath);
        if (workspaces.exists(this.workspaceName)) {
            if (!this.useUpdate) {
                workspaceNamesToDelete.add(this.workspaceName);
            }
            if (existingWorkspaceName == null) {
                logger.println("Warning: Although the server thinks the workspace exists, no mapping was found.");
                workspaceNamesToDelete.add(this.workspaceName);
            } else if (!existingWorkspaceName.equalsIgnoreCase(this.workspaceName)) {
                String template = "WARNING: Workspace '%s' already exists AND '%s' is also mapped in workspace '%s'.  Is there a configuration error?";
                message = String.format("WARNING: Workspace '%s' already exists AND '%s' is also mapped in workspace '%s'.  Is there a configuration error?", this.workspaceName, localPath, existingWorkspaceName);
                logger.println(message);
                workspaceNamesToDelete.add(this.workspaceName);
                workspaceNamesToDelete.add(existingWorkspaceName);
            }
            boolean localFolderExists = localFolderPath.exists();
            if (!localFolderExists) {
                logger.println("Warning: The local folder is missing.");
                workspaceNamesToDelete.add(this.workspaceName);
            }
        } else if (existingWorkspaceName != null && !existingWorkspaceName.equalsIgnoreCase(this.workspaceName)) {
            String template = "Workspace was apparently renamed, will delete the old one: '%s'.";
            message = String.format("Workspace was apparently renamed, will delete the old one: '%s'.", existingWorkspaceName);
            logger.println(message);
            workspaceNamesToDelete.add(existingWorkspaceName);
        }
        for (String workspaceNameToDelete : workspaceNamesToDelete) {
            Workspace workspace2 = workspaces.getWorkspace(workspaceNameToDelete);
            workspaces.deleteWorkspace(workspace2);
        }
        if (!workspaces.exists(this.workspaceName)) {
            if ((!this.useUpdate || workspaceNamesToDelete.size() > 0) && localFolderPath.exists()) {
                localFolderPath.deleteContents();
            }
            String serverPath = project.getProjectPath();
            workspace = workspaces.newWorkspace(this.workspaceName, serverPath, this.cloakedPaths, localPath);
        } else {
            workspace = workspaces.getWorkspace(this.workspaceName);
        }
        return project;
    }
}

