/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs;

import com.microsoft.visualstudio.services.webapi.model.ResourceRef;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.tfs.TeamPullRequestMergedDetailsAction;
import hudson.plugins.tfs.telemetry.TelemetryHelper;
import hudson.plugins.tfs.util.TeamRestClient;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.kohsuke.stapler.DataBoundConstructor;

public class TeamUpdateWorkItemPostBuildAction
extends Notifier
implements SimpleBuildStep {
    @DataBoundConstructor
    public TeamUpdateWorkItemPostBuildAction() {
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        try {
            String absoluteUrl = run.getAbsoluteUrl();
            ArrayList<ResourceRef> workItems = new ArrayList<ResourceRef>();
            URI collectionUri = TeamPullRequestMergedDetailsAction.addWorkItemsForRun(run, workItems);
            if (collectionUri != null) {
                TeamRestClient client = new TeamRestClient(collectionUri);
                for (ResourceRef workItem : workItems) {
                    String workItemIdString = workItem.getId();
                    Integer workItemId = Integer.valueOf(workItemIdString, 10);
                    client.addHyperlinkToWorkItem(workItemId, absoluteUrl);
                }
                TelemetryHelper.sendEvent("team-workitem-update", new TelemetryHelper.PropertyMapBuilder().serverContext(collectionUri.toString(), collectionUri.toString()).build());
            }
        }
        catch (IllegalArgumentException e) {
            listener.error(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace(listener.error("Error while trying to update associated work items in TFS/Team Services"));
        }
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Add link to associated work items in TFS/Team Services";
        }
    }
}

