/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs;

import hudson.model.Action;
import hudson.model.Run;
import hudson.plugins.tfs.util.EndpointHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.RunAction2;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.ForwardToView;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=999)
public class TeamResultsAction
implements RunAction2,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(TeamResultsAction.class.getName());
    public transient Run<?, ?> run;

    public void onAttached(Run<?, ?> r) {
        this.run = r;
    }

    public void onLoad(Run<?, ?> r) {
        this.run = r;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "team-results";
    }

    public static void addToRun(Run<?, ?> run) {
        TeamResultsAction action = new TeamResultsAction();
        run.addAction((Action)action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doZip(StaplerRequest req, StaplerResponse rsp) throws IOException {
        try {
            if (this.run == null) {
                throw new IllegalArgumentException("There is no associated Run<?,?>");
            }
            File rootDir = this.run.getRootDir();
            File resultsZipFile = new File(rootDir, "team-results.zip");
            if (!resultsZipFile.isFile()) {
                throw new IllegalArgumentException("There is no results file in this build");
            }
            FileInputStream resultsZipStream = new FileInputStream(resultsZipFile);
            rsp.setContentType("application/zip");
            long lastModified = resultsZipFile.lastModified();
            long contentLength = resultsZipFile.length();
            String fileName = resultsZipFile.getName();
            try {
                rsp.serveFile(req, (InputStream)resultsZipStream, lastModified, contentLength, fileName);
            }
            finally {
                IOUtils.closeQuietly((InputStream)resultsZipStream);
            }
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.WARNING, "IllegalArgumentException", e);
            EndpointHelper.error(400, e);
        }
        catch (ForwardToView e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unknown error", e);
            EndpointHelper.error(500, e);
        }
    }
}

