/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs;

import hudson.Extension;
import hudson.Util;
import hudson.console.AnnotatedLargeText;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.TaskListener;
import hudson.model.queue.QueueTaskFuture;
import hudson.plugins.tfs.TeamPushCause;
import hudson.plugins.tfs.model.GitCodePushedEventArgs;
import hudson.plugins.tfs.util.ActionHelper;
import hudson.plugins.tfs.util.MediaType;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.triggers.SCMTriggerItem;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class TeamPushTrigger
extends Trigger<Job<?, ?>> {
    private static final Logger LOGGER = Logger.getLogger(TeamPushTrigger.class.getName());
    private String jobContext;

    @DataBoundConstructor
    public TeamPushTrigger() {
    }

    public TeamPushTrigger(Job<?, ?> job) {
        this.job = job;
    }

    public TeamPushTrigger(Job<?, ?> job, String jobContext) {
        this.job = job;
        this.jobContext = jobContext;
    }

    public void execute(GitCodePushedEventArgs gitCodePushedEventArgs, List<Action> actions, boolean bypassPolling) {
        Runner runner = new Runner(gitCodePushedEventArgs, actions, bypassPolling);
        runner.run();
    }

    public File getLogFile() {
        return new File(((Job)this.job).getRootDir(), "team-polling.log");
    }

    public String getJobContext() {
        return this.jobContext;
    }

    @DataBoundSetter
    public void setJobContext(String jobContext) {
        this.jobContext = jobContext;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public Collection<? extends Action> getProjectActions() {
        if (this.job == null) {
            return Collections.emptyList();
        }
        return Collections.singleton(new TeamPollingAction());
    }

    public final class TeamPollingAction
    implements Action {
        public String getIconFileName() {
            return "/plugin/tfs/48x48/logo.png";
        }

        public String getDisplayName() {
            return "TFS/Team Services hook log";
        }

        public String getUrlName() {
            return "TeamPollLog";
        }

        public Job<?, ?> getOwner() {
            return (Job)TeamPushTrigger.this.job;
        }

        public String getLog() throws IOException {
            return Util.loadFile((File)TeamPushTrigger.this.getLogFile());
        }

        public void writeLogTo(XMLOutput out) throws IOException {
            File logFile = TeamPushTrigger.this.getLogFile();
            AnnotatedLargeText text = new AnnotatedLargeText(logFile, MediaType.UTF_8, true, (Object)this);
            Writer writer = out.asWriter();
            text.writeHtmlTo(0L, writer);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends TriggerDescriptor {
        public boolean isApplicable(Item item) {
            return item instanceof Job && SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem((Item)item) != null && item instanceof ParameterizedJobMixIn.ParameterizedJob;
        }

        public String getDisplayName() {
            return "Build when a change is pushed to TFS/Team Services";
        }
    }

    public class Runner
    implements Runnable {
        private final GitCodePushedEventArgs gitCodePushedEventArgs;
        private final List<Action> actions;
        private final boolean bypassPolling;

        public Runner(GitCodePushedEventArgs gitCodePushedEventArgs, List<Action> actions, boolean bypassPolling) {
            this.gitCodePushedEventArgs = gitCodePushedEventArgs;
            this.actions = actions;
            this.bypassPolling = bypassPolling;
        }

        private SCMTriggerItem job() {
            return SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem((Item)TeamPushTrigger.this.job);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean runPolling() {
            String failedToRecord = "Failed to record SCM polling for " + TeamPushTrigger.this.job;
            try (StreamTaskListener listener = new StreamTaskListener(TeamPushTrigger.this.getLogFile(), MediaType.UTF_8);){
                PrintStream logger = listener.getLogger();
                long startTimeMillis = System.currentTimeMillis();
                Date date = new Date(startTimeMillis);
                logger.println("Started on " + DateFormat.getDateTimeInstance().format(date));
                boolean result = this.job().poll((TaskListener)listener).hasChanges();
                long endTimeMillis = System.currentTimeMillis();
                logger.println("Done. Took " + Util.getTimeSpanString((long)(endTimeMillis - startTimeMillis)));
                if (result) {
                    logger.println("Changes found");
                } else {
                    logger.println("No changes");
                }
                boolean bl = result;
                return bl;
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, failedToRecord, e);
                return false;
            }
        }

        @Override
        public void run() {
            boolean shouldSchedule = this.bypassPolling;
            String changesDetected = "";
            if (!this.bypassPolling) {
                if (this.runPolling() || StringUtils.isNotBlank((String)this.gitCodePushedEventArgs.commit)) {
                    changesDetected = "SCM changes detected in " + ((Job)TeamPushTrigger.this.job).getFullDisplayName() + ". ";
                    shouldSchedule = true;
                }
            } else {
                changesDetected = "Polling bypassed for " + ((Job)TeamPushTrigger.this.job).getFullDisplayName() + ". ";
            }
            if (shouldSchedule) {
                CauseAction causeAction;
                Action[] actionArray;
                int quietPeriod;
                QueueTaskFuture queueTaskFuture;
                TeamPushCause cause;
                SCMTriggerItem p = this.job();
                String name = "#" + p.getNextBuildNumber();
                String pushedBy = this.gitCodePushedEventArgs.pushedBy;
                File logFile = TeamPushTrigger.this.getLogFile();
                if (logFile.isFile()) {
                    try {
                        cause = new TeamPushCause(logFile, pushedBy, TeamPushTrigger.this.getJobContext());
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Failed to parse the polling log", e);
                        cause = new TeamPushCause(pushedBy, TeamPushTrigger.this.getJobContext());
                    }
                } else {
                    cause = new TeamPushCause(pushedBy, TeamPushTrigger.this.getJobContext());
                }
                if ((queueTaskFuture = p.scheduleBuild2(quietPeriod = p.getQuietPeriod(), actionArray = ActionHelper.create(this.actions, new Action[]{causeAction = new CauseAction((Cause)cause)}))) != null) {
                    LOGGER.info(changesDetected + "Triggering " + name);
                } else {
                    LOGGER.info(changesDetected + "Job is already in the queue");
                }
            }
        }
    }
}

