/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs;

import com.microsoft.teamfoundation.core.webapi.model.TeamProjectReference;
import com.microsoft.teamfoundation.sourcecontrol.webapi.model.GitRepository;
import com.microsoft.visualstudio.services.webapi.model.ResourceRef;
import hudson.model.Action;
import hudson.model.Run;
import hudson.plugins.tfs.model.GitPullRequestEx;
import hudson.plugins.tfs.util.UriHelper;
import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=999)
public class TeamPullRequestMergedDetailsAction
implements Action,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String URL_NAME = "team-pullRequestMergedDetails";
    public transient GitPullRequestEx gitPullRequest;
    public String message;
    public String detailedMessage;
    public String collectionUri;

    public TeamPullRequestMergedDetailsAction() {
    }

    public TeamPullRequestMergedDetailsAction(GitPullRequestEx gitPullRequest, String message, String detailedMessage, String collectionUri) {
        this.gitPullRequest = gitPullRequest;
        this.message = message;
        this.detailedMessage = detailedMessage;
        this.collectionUri = collectionUri;
    }

    public static URI addWorkItemsForRun(Run<?, ?> run, List<ResourceRef> destination) {
        TeamPullRequestMergedDetailsAction action = (TeamPullRequestMergedDetailsAction)run.getAction(TeamPullRequestMergedDetailsAction.class);
        if (action != null && action.hasWorkItems()) {
            Collections.addAll(destination, action.getWorkItems());
            GitPullRequestEx gitPullRequest = action.gitPullRequest;
            URI collectionUri = URI.create(action.collectionUri);
            return collectionUri;
        }
        return null;
    }

    public String getIconFileName() {
        return "/plugin/tfs/48x48/logo.png";
    }

    public String getDisplayName() {
        return "TFS/Team Services pull request";
    }

    public String getUrlName() {
        return URL_NAME;
    }

    @Exported
    public String getMessage() {
        return this.message;
    }

    @Exported
    public String getDetailedMessage() {
        return this.detailedMessage;
    }

    @Exported
    public ResourceRef[] getWorkItems() {
        return this.gitPullRequest.getWorkItemRefs();
    }

    @Exported
    public boolean hasWorkItems() {
        ResourceRef[] workItemRefs = this.gitPullRequest.getWorkItemRefs();
        return workItemRefs != null && workItemRefs.length > 0;
    }

    @Exported
    public String getPullRequestUrl() {
        GitRepository repository = this.gitPullRequest.getRepository();
        URI collectionUri = URI.create(this.collectionUri);
        TeamProjectReference project = repository.getProject();
        URI pullRequestUrl = UriHelper.join(collectionUri, project.getName(), "_git", repository.getName(), "pullrequest", this.gitPullRequest.getPullRequestId());
        String result = pullRequestUrl.toString();
        return result;
    }
}

