/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Descriptor;
import hudson.plugins.tfs.TeamCollectionConfiguration;
import hudson.plugins.tfs.model.DomainUserAccountMapper;
import hudson.plugins.tfs.model.UserAccountMapper;
import hudson.plugins.tfs.model.UserAccountMapperDescriptor;
import hudson.plugins.tfs.rm.ReleaseWebHook;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.ObjectUtils;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class TeamPluginGlobalConfig
extends GlobalConfiguration {
    private static final Logger LOGGER = Logger.getLogger(TeamPluginGlobalConfig.class.getName());
    public static final TeamPluginGlobalConfig DEFAULT_CONFIG = new TeamPluginGlobalConfig(false);
    private List<TeamCollectionConfiguration> collectionConfigurations = new ArrayList<TeamCollectionConfiguration>();
    private List<ReleaseWebHook> releaseWebHookConfigurations = new ArrayList<ReleaseWebHook>();
    private boolean configFolderPerNode;
    private boolean enableTeamPushTriggerForAllJobs;
    private boolean enableTeamStatusForAllJobs;
    private UserAccountMapper userAccountMapper;

    public TeamPluginGlobalConfig() {
        this(true);
    }

    TeamPluginGlobalConfig(boolean shouldLoadConfig) {
        if (shouldLoadConfig) {
            this.load();
        }
    }

    public TeamPluginGlobalConfig(List<TeamCollectionConfiguration> collectionConfigurations) {
        this.collectionConfigurations = collectionConfigurations;
    }

    public static TeamPluginGlobalConfig get() {
        TeamPluginGlobalConfig result = DEFAULT_CONFIG;
        if (Jenkins.getInstance() != null) {
            ExtensionList configurationExtensions = TeamPluginGlobalConfig.all();
            TeamPluginGlobalConfig config = (TeamPluginGlobalConfig)((Object)configurationExtensions.get(TeamPluginGlobalConfig.class));
            result = (TeamPluginGlobalConfig)((Object)ObjectUtils.defaultIfNull((Object)((Object)config), (Object)((Object)DEFAULT_CONFIG)));
        }
        return result;
    }

    public List<TeamCollectionConfiguration> getCollectionConfigurations() {
        return this.collectionConfigurations;
    }

    public void setCollectionConfigurations(List<TeamCollectionConfiguration> collectionConfigurations) {
        this.collectionConfigurations = collectionConfigurations;
    }

    public List<ReleaseWebHook> getReleaseWebHookConfigurations() {
        return this.releaseWebHookConfigurations;
    }

    public void setReleaseWebHookConfigurations(List<ReleaseWebHook> releaseWebHookConfigurations) {
        this.releaseWebHookConfigurations = releaseWebHookConfigurations;
    }

    public boolean isConfigFolderPerNode() {
        return this.configFolderPerNode;
    }

    public void setConfigFolderPerNode(boolean configFolderPerNode) {
        this.configFolderPerNode = configFolderPerNode;
    }

    public boolean isEnableTeamPushTriggerForAllJobs() {
        return this.enableTeamPushTriggerForAllJobs;
    }

    public void setEnableTeamPushTriggerForAllJobs(boolean enableTeamPushTriggerForAllJobs) {
        this.enableTeamPushTriggerForAllJobs = enableTeamPushTriggerForAllJobs;
    }

    public boolean isEnableTeamStatusForAllJobs() {
        return this.enableTeamStatusForAllJobs;
    }

    public void setEnableTeamStatusForAllJobs(boolean enableTeamStatusForAllJobs) {
        this.enableTeamStatusForAllJobs = enableTeamStatusForAllJobs;
    }

    public UserAccountMapper getUserAccountMapper() {
        if (this.userAccountMapper == null) {
            this.userAccountMapper = new DomainUserAccountMapper();
        }
        return this.userAccountMapper;
    }

    public void setUserAccountMapper(UserAccountMapper userAccountMapper) {
        this.userAccountMapper = userAccountMapper;
    }

    public List<UserAccountMapperDescriptor> getUserAccountMapperDescriptors() {
        return UserAccountMapper.all();
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        try {
            req.bindJSON((Object)this, json);
            this.releaseWebHookConfigurations = req.bindJSONToList(ReleaseWebHook.class, json.get("releaseWebHookConfigurations"));
        }
        catch (Exception e) {
            String message = "Configuration error: " + e.getMessage();
            LOGGER.log(Level.WARNING, message, e);
            LOGGER.log(Level.FINE, "Form data: {}", json.toString());
            throw new Descriptor.FormException(message, (Throwable)e, "team-configuration");
        }
        this.save();
        return true;
    }

    public String getDisplayName() {
        return "TFS/Team Services";
    }
}

