/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.ChangesetVersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.DateVersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.VersionSpec;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.ParametersAction;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.tfs.ChangeSetReader;
import hudson.plugins.tfs.ChangeSetWriter;
import hudson.plugins.tfs.TFSRevisionState;
import hudson.plugins.tfs.TeamBuildDetailsAction;
import hudson.plugins.tfs.TeamCollectionConfiguration;
import hudson.plugins.tfs.TeamPluginGlobalConfig;
import hudson.plugins.tfs.actions.CheckoutAction;
import hudson.plugins.tfs.actions.RemoveWorkspaceAction;
import hudson.plugins.tfs.browsers.TeamFoundationServerRepositoryBrowser;
import hudson.plugins.tfs.browsers.TeamSystemWebAccessBrowser;
import hudson.plugins.tfs.model.ChangeSet;
import hudson.plugins.tfs.model.CredentialsConfigurer;
import hudson.plugins.tfs.model.CredentialsConfigurerDescriptor;
import hudson.plugins.tfs.model.ManualCredentialsConfigurer;
import hudson.plugins.tfs.model.Project;
import hudson.plugins.tfs.model.Server;
import hudson.plugins.tfs.model.WorkspaceConfiguration;
import hudson.plugins.tfs.util.BuildVariableResolver;
import hudson.plugins.tfs.util.BuildWorkspaceConfigurationRetriever;
import hudson.scm.ChangeLogParser;
import hudson.scm.PollingResult;
import hudson.scm.RepositoryBrowser;
import hudson.scm.RepositoryBrowsers;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import hudson.util.LogTaskListener;
import hudson.util.Scrambler;
import hudson.util.Secret;
import hudson.util.VariableResolver;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class TeamFoundationServerScm
extends SCM {
    public static final String WORKSPACE_ENV_STR = "TFS_WORKSPACE";
    public static final String WORKFOLDER_ENV_STR = "TFS_WORKFOLDER";
    public static final String PROJECTPATH_ENV_STR = "TFS_PROJECTPATH";
    public static final String SERVERURL_ENV_STR = "TFS_SERVERURL";
    public static final String USERNAME_ENV_STR = "TFS_USERNAME";
    public static final String WORKSPACE_CHANGESET_ENV_STR = "TFS_CHANGESET";
    private static final String VERSION_SPEC = "VERSION_SPEC";
    private static final int RADIX_10 = 10;
    private final String serverUrl;
    private final String projectPath;
    private Collection<String> cloakedPaths;
    private String localPath;
    private final String workspaceName;
    @Deprecated
    private String userPassword;
    private Secret password;
    private String userName;
    private CredentialsConfigurer credentialsConfigurer;
    private boolean useUpdate;
    private boolean useOverwrite;
    private String versionSpec;
    private TeamFoundationServerRepositoryBrowser repositoryBrowser;
    private transient String normalizedWorkspaceName;
    private transient String workspaceChangesetVersion;
    private static final Logger logger = Logger.getLogger(TeamFoundationServerScm.class.getName());

    TeamFoundationServerScm(String serverUrl, String projectPath, String workspaceName) {
        this(serverUrl, projectPath, workspaceName, null, null);
    }

    @DataBoundConstructor
    public TeamFoundationServerScm(String serverUrl, String projectPath, String workspaceName, String userName, Secret password) {
        this.serverUrl = serverUrl;
        this.projectPath = projectPath;
        this.workspaceName = Util.fixEmptyAndTrim((String)workspaceName) == null ? "Hudson-${JOB_NAME}-${NODE_NAME}" : workspaceName;
        this.userName = userName;
        this.password = password;
    }

    private Object readResolve() {
        if (this.password == null && this.userPassword != null) {
            this.password = Secret.fromString((String)Scrambler.descramble((String)this.userPassword));
            this.userPassword = null;
        }
        if (this.userName != null && this.password != null) {
            this.credentialsConfigurer = new ManualCredentialsConfigurer(this.userName, this.password);
        }
        return this;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public String getLocalPath() {
        return Util.fixEmptyAndTrim((String)this.localPath) == null ? "." : this.localPath;
    }

    @DataBoundSetter
    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    public String getVersionSpec() {
        return this.versionSpec;
    }

    @DataBoundSetter
    public void setVersionSpec(String versionSpec) {
        this.versionSpec = versionSpec;
    }

    public boolean isUseUpdate() {
        return this.useUpdate;
    }

    @DataBoundSetter
    public void setUseUpdate(boolean useUpdate) {
        this.useUpdate = useUpdate;
    }

    public boolean isUseOverwrite() {
        return this.useOverwrite;
    }

    @DataBoundSetter
    public void setUseOverwrite(boolean useOverwrite) {
        this.useOverwrite = useOverwrite;
    }

    public String getUserPassword() {
        return Secret.toString((Secret)this.password);
    }

    public Secret getPassword() {
        return this.password;
    }

    public String getUserName() {
        return this.userName;
    }

    public CredentialsConfigurer getCredentialsConfigurer() {
        if (this.credentialsConfigurer == null) {
            this.credentialsConfigurer = new ManualCredentialsConfigurer(this.userName, this.password);
        }
        return this.credentialsConfigurer;
    }

    @DataBoundSetter
    public void setCredentialsConfigurer(CredentialsConfigurer credentialsConfigurer) {
        this.credentialsConfigurer = credentialsConfigurer;
    }

    public String getCloakedPaths() {
        return TeamFoundationServerScm.serializeCloakedPathCollectionToString(this.cloakedPaths);
    }

    @DataBoundSetter
    public void setCloakedPaths(String cloakedPaths) {
        this.cloakedPaths = TeamFoundationServerScm.splitCloakedPaths(cloakedPaths);
    }

    static String serializeCloakedPathCollectionToString(Collection<String> cloakedPaths) {
        return cloakedPaths == null ? "" : StringUtils.join(cloakedPaths, (String)"\n");
    }

    String getWorkspaceName(Run<?, ?> build, Computer computer) {
        this.normalizedWorkspaceName = this.workspaceName;
        if (build != null) {
            this.normalizedWorkspaceName = this.substituteBuildParameter(build, this.normalizedWorkspaceName);
            this.normalizedWorkspaceName = Util.replaceMacro((String)this.normalizedWorkspaceName, (VariableResolver)new BuildVariableResolver(build.getParent(), computer));
        }
        this.normalizedWorkspaceName = this.normalizedWorkspaceName.replaceAll("[\"/:<>\\|\\*\\?]+", "_");
        this.normalizedWorkspaceName = this.normalizedWorkspaceName.replaceAll("[\\.\\s]+$", "_");
        return this.normalizedWorkspaceName;
    }

    public String getServerUrl(Run<?, ?> run) {
        return this.substituteBuildParameter(run, this.serverUrl);
    }

    String getProjectPath(Run<?, ?> run) {
        return Util.replaceMacro((String)this.substituteBuildParameter(run, this.projectPath), (VariableResolver)new BuildVariableResolver(run.getParent()));
    }

    Collection<String> getCloakedPaths(Run<?, ?> run) {
        ArrayList<String> paths = new ArrayList<String>();
        if (this.cloakedPaths != null) {
            BuildVariableResolver resolver = new BuildVariableResolver(run.getParent());
            for (String cloakedPath : this.cloakedPaths) {
                String path = this.substituteBuildParameter(run, cloakedPath);
                String enhancedPath = Util.replaceMacro((String)path, (VariableResolver)resolver);
                paths.add(enhancedPath);
            }
        }
        return paths;
    }

    private String substituteBuildParameter(Run<?, ?> run, String text) {
        AbstractBuild build;
        if (run instanceof AbstractBuild && (build = (AbstractBuild)run).getAction(ParametersAction.class) != null) {
            return ((ParametersAction)build.getAction(ParametersAction.class)).substitute(build, text);
        }
        return text;
    }

    static Collection<String> splitCloakedPaths(String cloakedPaths) {
        ArrayList<String> cloakedPathsList = new ArrayList<String>();
        if (cloakedPaths != null && cloakedPaths.length() > 0) {
            StringBuilder cloakedPath = new StringBuilder(cloakedPaths.length());
            block3: for (char character : cloakedPaths.toCharArray()) {
                switch (character) {
                    case '\n': {
                        if (cloakedPath.length() <= 0) continue block3;
                        cloakedPathsList.add(cloakedPath.toString().trim());
                        cloakedPath.setLength(0);
                        continue block3;
                    }
                    default: {
                        cloakedPath.append(character);
                    }
                }
            }
            if (cloakedPath.length() > 0) {
                cloakedPathsList.add(cloakedPath.toString().trim());
            }
        }
        return cloakedPathsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkout(Run<?, ?> build, Launcher launcher, FilePath workspaceFilePath, TaskListener listener, File changelogFile, SCMRevisionState baseline) throws IOException, InterruptedException {
        try (Server server = this.createServer(launcher, listener, build);){
            List<ChangeSet> list;
            BuildWorkspaceConfigurationRetriever.BuildWorkspaceConfiguration nodeConfiguration;
            Computer computer;
            WorkspaceConfiguration workspaceConfiguration = new WorkspaceConfiguration(server.getUrl(), this.getWorkspaceName(build, workspaceFilePath.toComputer()), this.getProjectPath(build), this.getCloakedPaths(build), this.getLocalPath());
            Run previousBuild = build.getPreviousBuild();
            if (previousBuild != null && (computer = workspaceFilePath.toComputer()) != null && (nodeConfiguration = new BuildWorkspaceConfigurationRetriever().getLatestForNode(computer.getNode(), previousBuild)) != null && nodeConfiguration.workspaceExists() && !workspaceConfiguration.equals(nodeConfiguration)) {
                listener.getLogger().println("Deleting workspace as the configuration has changed since a build was performed on this computer.");
                new RemoveWorkspaceAction(workspaceConfiguration.getWorkspaceName()).remove(server);
                nodeConfiguration.setWorkspaceWasRemoved();
                nodeConfiguration.save();
            }
            build.addAction((Action)workspaceConfiguration);
            String singleVersionSpec = this.versionSpec;
            if (build instanceof AbstractBuild) {
                VariableResolver buildVariableResolver = ((AbstractBuild)build).getBuildVariableResolver();
                singleVersionSpec = (String)buildVariableResolver.resolve(VERSION_SPEC);
            }
            String projPath = workspaceConfiguration.getProjectPath();
            Project project = server.getProject(projPath);
            int changeSet = this.recordWorkspaceChangesetVersion(build, listener, project, projPath, singleVersionSpec);
            CheckoutAction action = new CheckoutAction(workspaceConfiguration.getWorkspaceName(), workspaceConfiguration.getProjectPath(), workspaceConfiguration.getCloakedPaths(), workspaceConfiguration.getWorkfolder(), this.isUseUpdate(), this.isUseOverwrite());
            if (StringUtils.isNotEmpty((String)singleVersionSpec)) {
                list = action.checkoutBySingleVersionSpec(server, workspaceFilePath, singleVersionSpec);
            } else {
                VersionSpec previousBuildVersionSpec = TeamFoundationServerScm.determineVersionSpecFromBuild(previousBuild, 1, changeSet);
                ChangesetVersionSpec currentBuildVersionSpec = new ChangesetVersionSpec(changeSet);
                list = action.checkout(server, workspaceFilePath, previousBuildVersionSpec, (VersionSpec)currentBuildVersionSpec);
            }
            if (changelogFile != null) {
                ChangeSetWriter writer = new ChangeSetWriter();
                writer.write(list, changelogFile);
            }
        }
    }

    static VersionSpec determineVersionSpecFromBuild(Run<?, ?> build, int offset, int maximumChangeSetNumber) {
        int changeSetNumber;
        TFSRevisionState revisionState;
        ChangesetVersionSpec result = build != null ? ((revisionState = (TFSRevisionState)build.getAction(TFSRevisionState.class)) != null ? ((changeSetNumber = revisionState.changesetVersion + offset) <= maximumChangeSetNumber ? new ChangesetVersionSpec(changeSetNumber) : null) : null) : null;
        return result;
    }

    int recordWorkspaceChangesetVersion(Run<?, ?> build, TaskListener listener, Project project, String projectPath, String singleVersionSpec) throws IOException, InterruptedException {
        Object workspaceVersion = !StringUtils.isEmpty((String)singleVersionSpec) ? VersionSpec.parseSingleVersionFromSpec((String)singleVersionSpec, null) : new DateVersionSpec(build.getTimestamp());
        this.setWorkspaceChangesetVersion(null);
        int buildChangeset = project.getRemoteChangesetVersion((VersionSpec)workspaceVersion);
        this.setWorkspaceChangesetVersion(Integer.toString(buildChangeset, 10));
        build.addAction((Action)new TFSRevisionState(buildChangeset, projectPath));
        return buildChangeset;
    }

    void setWorkspaceChangesetVersion(String workspaceChangesetVersion) {
        this.workspaceChangesetVersion = workspaceChangesetVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pollChanges(AbstractProject hudsonProject, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        AbstractBuild lastRun = hudsonProject.getLastBuild();
        if (lastRun == null) {
            return true;
        }
        try (Server server = this.createServer(launcher, listener, (Run<?, ?>)lastRun);){
            boolean bl = server.getProject(this.getProjectPath((Run<?, ?>)lastRun)).getDetailedHistoryWithoutCloakedPaths(lastRun.getTimestamp(), Calendar.getInstance(), this.getCloakedPaths((Run<?, ?>)lastRun)).size() > 0;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processWorkspaceBeforeDeletion(Job<?, ?> project, FilePath workspace, Node node) throws IOException, InterruptedException {
        BuildWorkspaceConfigurationRetriever.BuildWorkspaceConfiguration configuration;
        Node nodeIter = node;
        Run lastRun = project.getLastBuild();
        if (lastRun == null) {
            return true;
        }
        if (nodeIter == null) {
            while (lastRun != null) {
                if (!(lastRun instanceof AbstractBuild)) {
                    return false;
                }
                AbstractBuild build = (AbstractBuild)lastRun;
                Node buildNode = build.getBuiltOn();
                if (nodeIter == null) {
                    nodeIter = buildNode;
                } else if (!buildNode.getNodeName().equals(nodeIter.getNodeName())) {
                    logger.warning("Could not wipe out workspace as there is no way of telling what Node the request is for. Please upgrade Hudson to a newer version.");
                    return false;
                }
                lastRun = lastRun.getPreviousBuild();
            }
            if (nodeIter == null) {
                return true;
            }
            lastRun = project.getLastBuild();
        }
        if ((configuration = new BuildWorkspaceConfigurationRetriever().getLatestForNode(nodeIter, lastRun)) != null && configuration.workspaceExists()) {
            LogTaskListener listener = new LogTaskListener(logger, Level.INFO);
            Launcher launcher = nodeIter.createLauncher((TaskListener)listener);
            try (Server server = this.createServer(launcher, (TaskListener)listener, lastRun);){
                if (new RemoveWorkspaceAction(configuration.getWorkspaceName()).remove(server)) {
                    configuration.setWorkspaceWasRemoved();
                    configuration.save();
                }
            }
        }
        return true;
    }

    protected Server createServer(Launcher launcher, TaskListener taskListener, Run<?, ?> run) throws IOException {
        CredentialsConfigurer credentialsConfig = this.getCredentialsConfigurer();
        String collectionUri = this.getServerUrl(run);
        StandardUsernamePasswordCredentials credentials = credentialsConfig.getCredentials(collectionUri);
        return Server.create(launcher, taskListener, collectionUri, credentials, null, null);
    }

    public boolean requiresWorkspaceForPolling() {
        return false;
    }

    public boolean supportsPolling() {
        return true;
    }

    public ChangeLogParser createChangeLogParser() {
        return new ChangeSetReader();
    }

    public FilePath getModuleRoot(FilePath workspace) {
        return workspace.child(this.getLocalPath());
    }

    public TeamFoundationServerRepositoryBrowser getBrowser() {
        return this.repositoryBrowser;
    }

    @CheckForNull
    public RepositoryBrowser<?> guessBrowser() {
        return new TeamSystemWebAccessBrowser(this.serverUrl);
    }

    public void setRepositoryBrowser(TeamFoundationServerRepositoryBrowser repositoryBrowser) {
        this.repositoryBrowser = repositoryBrowser;
    }

    public void buildEnvVars(AbstractBuild<?, ?> build, Map<String, String> env) {
        this.buildEnvironment((Run<?, ?>)build, env);
    }

    public void buildEnvironment(Run<?, ?> build, Map<String, String> env) {
        TeamBuildDetailsAction buildDetailsAction = (TeamBuildDetailsAction)build.getAction(TeamBuildDetailsAction.class);
        if (buildDetailsAction != null) {
            for (Map.Entry<String, String> entry : buildDetailsAction.buildVariables.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (value == null) continue;
                env.put(key.replace('.', '_').toUpperCase(), value);
            }
        }
        if (this.normalizedWorkspaceName != null) {
            env.put(WORKSPACE_ENV_STR, this.normalizedWorkspaceName);
        }
        if (env.containsKey("WORKSPACE")) {
            env.put(WORKFOLDER_ENV_STR, env.get("WORKSPACE") + File.separator + this.getLocalPath());
        }
        if (this.projectPath != null) {
            env.put(PROJECTPATH_ENV_STR, this.projectPath);
        }
        if (this.serverUrl != null) {
            env.put(SERVERURL_ENV_STR, this.serverUrl);
        }
        if (this.userName != null) {
            env.put(USERNAME_ENV_STR, this.userName);
        }
        if (this.workspaceChangesetVersion != null && this.workspaceChangesetVersion.length() > 0) {
            env.put(WORKSPACE_CHANGESET_ENV_STR, this.workspaceChangesetVersion);
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public SCMRevisionState calcRevisionsFromBuild(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        return SCMRevisionState.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollingResult compareRemoteRevisionWith(Job<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener, SCMRevisionState baseline) throws IOException, InterruptedException {
        Launcher localLauncher = launcher != null ? launcher : new Launcher.LocalLauncher(listener);
        Run build = project.getLastBuild();
        Server server = this.createServer(localLauncher, listener, build);
        if (!(baseline instanceof TFSRevisionState)) {
            if (project instanceof AbstractProject) {
                boolean shouldBuild = this.pollChanges((AbstractProject)project, localLauncher, workspace, listener);
                return shouldBuild ? PollingResult.BUILD_NOW : PollingResult.NO_CHANGES;
            }
            if (build == null) {
                return PollingResult.BUILD_NOW;
            }
            try {
                PollingResult shouldBuild = server.getProject(this.getProjectPath(build)).getDetailedHistoryWithoutCloakedPaths(build.getTimestamp(), Calendar.getInstance(), this.getCloakedPaths(build)).size() > 0 ? PollingResult.BUILD_NOW : PollingResult.NO_CHANGES;
                return shouldBuild;
            }
            finally {
                server.close();
            }
        }
        TFSRevisionState tfsBaseline = (TFSRevisionState)baseline;
        if (!this.projectPath.equalsIgnoreCase(tfsBaseline.projectPath)) {
            return PollingResult.BUILD_NOW;
        }
        Project tfsProject = server.getProject(this.projectPath);
        try {
            ChangeSet latest = tfsProject.getLatestUncloakedChangeset(tfsBaseline.changesetVersion, this.cloakedPaths);
            TFSRevisionState tfsRemote = latest != null ? new TFSRevisionState(latest.getVersion(), this.projectPath) : tfsBaseline;
            PollingResult.Change change = tfsBaseline.changesetVersion == tfsRemote.changesetVersion ? PollingResult.Change.NONE : PollingResult.Change.SIGNIFICANT;
            PollingResult pollingResult = new PollingResult((SCMRevisionState)tfsBaseline, (SCMRevisionState)tfsRemote, change);
            return pollingResult;
        }
        catch (Exception e) {
            e.printStackTrace(listener.fatalError(e.getMessage()));
            PollingResult pollingResult = PollingResult.NO_CHANGES;
            return pollingResult;
        }
        finally {
            server.close();
        }
    }

    @Extension
    public static class DescriptorImpl
    extends SCMDescriptor<TeamFoundationServerScm> {
        public static final Pattern WORKSPACE_NAME_REGEX = Pattern.compile("[^\"/:<>\\|\\*\\?]+[^\\s\\.\"/:<>\\|\\*\\?]$", 2);
        public static final Pattern PROJECT_PATH_REGEX = Pattern.compile("^\\$\\/.*", 2);
        public static final Pattern CLOAKED_PATHS_REGEX = Pattern.compile("\\s*\\$[^\\n;]+(\\s*[\\n]\\s*\\$[^\\n;]+){0,}\\s*", 2);

        public boolean isApplicable(Job project) {
            return true;
        }

        public DescriptorImpl() {
            super(TeamFoundationServerScm.class, TeamFoundationServerRepositoryBrowser.class);
            this.load();
        }

        public SCM newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            TeamFoundationServerScm scm = (TeamFoundationServerScm)super.newInstance(req, formData);
            scm.repositoryBrowser = (TeamFoundationServerRepositoryBrowser)RepositoryBrowsers.createInstance(TeamFoundationServerRepositoryBrowser.class, (StaplerRequest)req, (JSONObject)formData, (String)"browser");
            if (scm.credentialsConfigurer instanceof ManualCredentialsConfigurer) {
                ManualCredentialsConfigurer manualCredentialsConfigurer = (ManualCredentialsConfigurer)scm.credentialsConfigurer;
                scm.userName = manualCredentialsConfigurer.getUserName();
                scm.password = manualCredentialsConfigurer.getPassword();
            }
            return scm;
        }

        private FormValidation doRegexCheck(Pattern[] regexArray, String noMatchText, String nullText, String value) {
            String val = value;
            if ((val = Util.fixEmpty((String)val)) == null) {
                if (nullText == null) {
                    return FormValidation.ok();
                }
                return FormValidation.error((String)nullText);
            }
            for (Pattern regex : regexArray) {
                if (!regex.matcher(val).matches()) continue;
                return FormValidation.ok();
            }
            return FormValidation.error((String)noMatchText);
        }

        public ComboBoxModel doFillServerUrlItems() {
            TeamPluginGlobalConfig pluginGlobalConfig = TeamPluginGlobalConfig.get();
            List<TeamCollectionConfiguration> collectionConfigurations = pluginGlobalConfig.getCollectionConfigurations();
            ComboBoxModel result = new ComboBoxModel(collectionConfigurations.size());
            for (TeamCollectionConfiguration collectionConfiguration : collectionConfigurations) {
                result.add((Object)collectionConfiguration.getCollectionUrl());
            }
            return result;
        }

        public FormValidation doProjectPathCheck(@QueryParameter String value) {
            return this.doRegexCheck(new Pattern[]{PROJECT_PATH_REGEX}, "Project path must begin with '$/'.", "Project path is mandatory.", value);
        }

        public FormValidation doWorkspaceNameCheck(@QueryParameter String value) {
            return this.doRegexCheck(new Pattern[]{WORKSPACE_NAME_REGEX}, "Workspace name cannot end with a space or period, and cannot contain any of the following characters: \"/:<>|*?", "Workspace name is mandatory", value);
        }

        public FormValidation doCloakedPathsCheck(@QueryParameter String value) {
            return this.doRegexCheck(new Pattern[]{CLOAKED_PATHS_REGEX}, "Each cloaked path must begin with '$/'. Multiple paths must be separated by blank lines.", null, value);
        }

        public List<CredentialsConfigurerDescriptor> getCredentialsConfigurerDescriptors() {
            return CredentialsConfigurer.all();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return true;
        }

        public String getDisplayName() {
            return "Team Foundation Version Control (TFVC)";
        }
    }
}

