/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs;

import hudson.Extension;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.UnprotectedRootAction;
import hudson.plugins.git.GitStatus;
import hudson.plugins.tfs.model.AbstractHookEvent;
import hudson.plugins.tfs.model.ConnectHookEvent;
import hudson.plugins.tfs.model.GitPullRequestMergedEvent;
import hudson.plugins.tfs.model.GitPushEvent;
import hudson.plugins.tfs.model.PingHookEvent;
import hudson.plugins.tfs.model.servicehooks.Event;
import hudson.plugins.tfs.rm.ConnectReleaseWebHookEvent;
import hudson.plugins.tfs.telemetry.TelemetryHelper;
import hudson.plugins.tfs.util.EndpointHelper;
import hudson.plugins.tfs.util.MediaType;
import hudson.plugins.tfs.util.StringBodyParameter;
import hudson.triggers.Trigger;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class TeamEventsEndpoint
implements UnprotectedRootAction {
    private static final Logger LOGGER = Logger.getLogger(TeamEventsEndpoint.class.getName());
    private static final Map<String, AbstractHookEvent.Factory> HOOK_EVENT_FACTORIES_BY_NAME;
    public static final String URL_NAME = "team-events";
    static final String URL_PREFIX = "/team-events/";

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return URL_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse doIndex(HttpServletRequest request) throws IOException {
        Class<?> me = this.getClass();
        InputStream stream = me.getResourceAsStream("TeamEventsEndpoint.html");
        Jenkins instance = Jenkins.getActiveInstance();
        String rootUrl = instance.getRootUrl();
        String eventRows = TeamEventsEndpoint.describeEvents(HOOK_EVENT_FACTORIES_BY_NAME, URL_NAME);
        try {
            String template = IOUtils.toString((InputStream)stream, (Charset)MediaType.UTF_8);
            String content = String.format(template, URL_NAME, eventRows, rootUrl);
            HttpResponse httpResponse = HttpResponses.html((String)content);
            return httpResponse;
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    static String describeEvents(Map<String, AbstractHookEvent.Factory> eventMap, String urlName) {
        String newLine = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, AbstractHookEvent.Factory> eventPair : eventMap.entrySet()) {
            String eventName = eventPair.getKey();
            AbstractHookEvent.Factory factory = eventPair.getValue();
            sb.append("<tr>").append(newLine);
            sb.append("<td valign='top'>").append(eventName).append("</td>").append(newLine);
            sb.append("<td valign='top'>").append('/').append(urlName).append('/').append(eventName).append("</td>").append(newLine);
            String rawSample = factory.getSampleRequestPayload();
            String escapedSample = StringEscapeUtils.escapeHtml4((String)rawSample);
            sb.append("<td><pre>").append(escapedSample).append("</pre></td>").append(newLine);
            sb.append("</tr>").append(newLine);
        }
        return sb.toString();
    }

    static String pathInfoToEventName(String pathInfo) {
        if (pathInfo.startsWith(URL_PREFIX)) {
            String restOfPath = pathInfo.substring(URL_PREFIX.length());
            int firstSlash = restOfPath.indexOf(47);
            String eventName = firstSlash != -1 ? restOfPath.substring(0, firstSlash) : restOfPath;
            return eventName;
        }
        return null;
    }

    void dispatch(StaplerRequest request, StaplerResponse rsp, String body) {
        String pathInfo = request.getPathInfo();
        String eventName = TeamEventsEndpoint.pathInfoToEventName(pathInfo);
        try {
            JSONObject response = TeamEventsEndpoint.innerDispatch(body, eventName, HOOK_EVENT_FACTORIES_BY_NAME);
            rsp.setStatus(200);
            rsp.setContentType("application/json; charset=utf-8");
            PrintWriter w = rsp.getWriter();
            String responseJsonString = response.toString();
            w.print(responseJsonString);
            w.println();
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.WARNING, "IllegalArgumentException", e);
            EndpointHelper.error(400, e);
        }
        catch (Exception e) {
            String template = "Error while performing reaction to '%s' event.";
            String message = String.format("Error while performing reaction to '%s' event.", eventName);
            LOGGER.log(Level.SEVERE, message, e);
            EndpointHelper.error(500, e);
        }
    }

    static JSONObject innerDispatch(String body, String eventName, Map<String, AbstractHookEvent.Factory> factoriesByName) throws IOException {
        if (StringUtils.isBlank((String)eventName) || !factoriesByName.containsKey(eventName)) {
            throw new IllegalArgumentException("Invalid event");
        }
        AbstractHookEvent.Factory factory = factoriesByName.get(eventName);
        Event serviceHookEvent = TeamEventsEndpoint.deserializeEvent(body);
        String message = serviceHookEvent.getMessage() != null ? serviceHookEvent.getMessage().getText() : "";
        String detailedMessage = serviceHookEvent.getDetailedMessage() != null ? serviceHookEvent.getDetailedMessage().getText() : "";
        AbstractHookEvent hookEvent = factory.create();
        return hookEvent.perform(EndpointHelper.MAPPER, serviceHookEvent, message, detailedMessage);
    }

    public static Event deserializeEvent(String input) throws IOException {
        Event serviceHookEvent = (Event)EndpointHelper.MAPPER.readValue(input, Event.class);
        String eventType = serviceHookEvent.getEventType();
        if (StringUtils.isEmpty((String)eventType)) {
            throw new IllegalArgumentException("Payload did not contain 'eventType'.");
        }
        Object resource = serviceHookEvent.getResource();
        if (resource == null) {
            throw new IllegalArgumentException("Payload did not contain 'resource'.");
        }
        return serviceHookEvent;
    }

    @RequirePOST
    public void doPing(StaplerRequest request, StaplerResponse response, @StringBodyParameter @Nonnull String body) {
        this.dispatch(request, response, body);
    }

    @RequirePOST
    public void doGitPullRequestMerged(StaplerRequest request, StaplerResponse response, @StringBodyParameter @Nonnull String body) {
        TelemetryHelper.sendEvent("team-events-git-pr-merged", new TelemetryHelper.PropertyMapBuilder().build());
        this.dispatch(request, response, body);
    }

    @RequirePOST
    public void doGitPush(StaplerRequest request, StaplerResponse response, @StringBodyParameter @Nonnull String body) {
        TelemetryHelper.sendEvent("team-events-git-push", new TelemetryHelper.PropertyMapBuilder().build());
        this.dispatch(request, response, body);
    }

    @RequirePOST
    public void doConnect(StaplerRequest request, StaplerResponse response, @StringBodyParameter @Nonnull String body) {
        TelemetryHelper.sendEvent("team-events-connect", new TelemetryHelper.PropertyMapBuilder().build());
        this.dispatch(request, response, body);
    }

    @RequirePOST
    public void doRmwebhook(StaplerRequest request, StaplerResponse response, @StringBodyParameter @Nonnull String body) {
        TelemetryHelper.sendEvent("team-events-rmwebhook", new TelemetryHelper.PropertyMapBuilder().build());
        this.dispatch(request, response, body);
    }

    public static <T extends Trigger> T findTrigger(Job<?, ?> job, Class<T> tClass) {
        if (job instanceof ParameterizedJobMixIn.ParameterizedJob) {
            ParameterizedJobMixIn.ParameterizedJob pJob = (ParameterizedJobMixIn.ParameterizedJob)job;
            for (Object trigger : pJob.getTriggers().values()) {
                if (!tClass.isInstance(trigger)) continue;
                return (T)((Trigger)tClass.cast(trigger));
            }
        }
        return null;
    }

    public static <T extends Trigger> List<T> findTriggers(Job<?, ?> job, Class<T> tClass) {
        ArrayList<T> triggerList = new ArrayList<T>();
        if (job instanceof ParameterizedJobMixIn.ParameterizedJob) {
            ParameterizedJobMixIn.ParameterizedJob pJob = (ParameterizedJobMixIn.ParameterizedJob)job;
            for (Object trigger : pJob.getTriggers().values()) {
                if (!tClass.isInstance(trigger)) continue;
                triggerList.add(tClass.cast(trigger));
            }
        }
        return triggerList;
    }

    static {
        TreeMap<String, AbstractHookEvent.Factory> eventMap = new TreeMap<String, AbstractHookEvent.Factory>(String.CASE_INSENSITIVE_ORDER);
        eventMap.put("ping", new PingHookEvent.Factory());
        eventMap.put("gitPullRequestMerged", new GitPullRequestMergedEvent.Factory());
        eventMap.put("gitPush", new GitPushEvent.Factory());
        eventMap.put("connect", new ConnectHookEvent.Factory());
        eventMap.put("rmWebhook", new ConnectReleaseWebHookEvent.Factory());
        HOOK_EVENT_FACTORIES_BY_NAME = Collections.unmodifiableMap(eventMap);
    }

    public static class ScheduledResponseContributor
    extends GitStatus.ResponseContributor {
        private final Item project;

        public ScheduledResponseContributor(Item project) {
            this.project = project;
        }

        public void addHeaders(StaplerRequest req, StaplerResponse rsp) {
            rsp.addHeader("Triggered", this.project.getAbsoluteUrl());
        }

        public void writeBody(PrintWriter w) {
            w.println("Scheduled " + this.project.getFullDisplayName());
        }
    }

    public static class PollingScheduledResponseContributor
    extends GitStatus.ResponseContributor {
        private final Item project;

        public PollingScheduledResponseContributor(Item project) {
            this.project = project;
        }

        public void addHeaders(StaplerRequest req, StaplerResponse rsp) {
            rsp.addHeader("Triggered", this.project.getAbsoluteUrl());
        }

        public void writeBody(PrintWriter w) {
            w.println("Scheduled polling of " + this.project.getFullDisplayName());
        }
    }
}

