/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.tfs.TeamGlobalStatusAction;
import hudson.plugins.tfs.util.TeamStatus;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.kohsuke.stapler.DataBoundConstructor;

public class TeamCompletedStatusPostBuildAction
extends Notifier
implements SimpleBuildStep {
    @DataBoundConstructor
    public TeamCompletedStatusPostBuildAction() {
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        if (!TeamGlobalStatusAction.isApplicable(run)) {
            this.perform(run, listener);
        }
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull TaskListener listener) {
        try {
            TeamStatus.createFromRun(run, listener, this.getDisplayName());
        }
        catch (IllegalArgumentException e) {
            listener.error(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace(listener.error("Error while trying to update completion status in TFS/Team Services"));
        }
    }

    String getDisplayName() {
        BuildStepDescriptor descriptor = this.getDescriptor();
        return descriptor.getDisplayName();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Set build completion status in TFS/Team Services";
        }
    }
}

