/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.HostnameRequirement;
import com.cloudbees.plugins.credentials.domains.HostnameSpecification;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import com.microsoft.tfs.core.exceptions.TFSUnauthorizedException;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.plugins.tfs.TeamPluginGlobalConfig;
import hudson.plugins.tfs.model.ConnectionParameters;
import hudson.plugins.tfs.model.ListOfGitRepositories;
import hudson.plugins.tfs.model.MockableVersionControlClient;
import hudson.plugins.tfs.model.Server;
import hudson.plugins.tfs.util.StringHelper;
import hudson.plugins.tfs.util.TeamRestClient;
import hudson.plugins.tfs.util.UriHelper;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class TeamCollectionConfiguration
extends AbstractDescribableImpl<TeamCollectionConfiguration> {
    private static final Logger LOGGER = Logger.getLogger(TeamCollectionConfiguration.class.getName());
    private final String collectionUrl;
    private final String credentialsId;
    private ConnectionParameters connectionParameters;

    @DataBoundConstructor
    public TeamCollectionConfiguration(String collectionUrl, String credentialsId) {
        this.collectionUrl = collectionUrl;
        this.credentialsId = credentialsId;
    }

    public String getCollectionUrl() {
        return this.collectionUrl;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public ConnectionParameters getConnectionParameters() {
        if (this.connectionParameters == null) {
            this.connectionParameters = new ConnectionParameters();
        }
        return this.connectionParameters;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    static FormValidation checkTeamServices(URI uri) {
        if (UriHelper.hasPath(uri)) {
            return FormValidation.error((String)"A Team Services collection URL must have an empty path.");
        }
        return FormValidation.ok();
    }

    static boolean areSameCollectionUri(URI a, URI b) {
        if (a == null) {
            throw new IllegalArgumentException("Parameter 'a' is null");
        }
        if (b == null) {
            throw new IllegalArgumentException("Parameter 'b' is null");
        }
        String aHost = a.getHost();
        String bHost = b.getHost();
        if (TeamCollectionConfiguration.isTeamServices(aHost) && TeamCollectionConfiguration.isTeamServices(bHost)) {
            return StringHelper.equalIgnoringCase(aHost, bHost);
        }
        return UriHelper.areSame(a, b);
    }

    public static boolean isTeamServices(String hostName) {
        return StringHelper.endsWithIgnoreCase(hostName, ".visualstudio.com");
    }

    static FormValidation testConnection(String collectionUri, StandardUsernamePasswordCredentials credentials) throws IOException {
        Server server = Server.create(null, null, collectionUri, credentials, null, null);
        try {
            MockableVersionControlClient vcc = server.getVersionControlClient();
            return FormValidation.ok((String)"Success via SOAP API.");
        }
        catch (TFSUnauthorizedException vcc) {
            TeamRestClient client = new TeamRestClient(collectionUri, credentials);
            try {
                ListOfGitRepositories repositories = client.getRepositories();
                if (repositories.count < 1) {
                    return FormValidation.warning((String)"There does not seem to be any Git repositories");
                }
                return FormValidation.ok((String)"Success via REST API.");
            }
            catch (IOException e) {
                return FormValidation.error((String)("Error: " + e.getMessage()));
            }
        }
    }

    static StandardUsernamePasswordCredentials findCredential(String hostName, String credentialsId) {
        List<StandardUsernamePasswordCredentials> matches = TeamCollectionConfiguration.findCredentials(hostName);
        CredentialsMatcher matcher = CredentialsMatchers.withId((String)credentialsId);
        StandardUsernamePasswordCredentials result = (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull(matches, (CredentialsMatcher)matcher);
        return result;
    }

    public static List<StandardUsernamePasswordCredentials> findCredentials(String hostName) {
        Jenkins jenkins = Jenkins.getInstance();
        return TeamCollectionConfiguration.findCredentials(hostName, (ItemGroup)jenkins);
    }

    public static List<StandardUsernamePasswordCredentials> findCredentials(String hostName, ItemGroup own) {
        HostnameRequirement requirement = new HostnameRequirement(hostName);
        List matches = CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)own, (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{requirement});
        return matches;
    }

    public static List<StandardUsernamePasswordCredentials> findCredentials(String hostName, Item own) {
        HostnameRequirement requirement = new HostnameRequirement(hostName);
        List matches = CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)own, (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{requirement});
        return matches;
    }

    public static StandardUsernamePasswordCredentials findCredentialsById(String credentialsId) {
        Jenkins jenkins = Jenkins.getInstance();
        List matches = CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)jenkins, (Authentication)ACL.SYSTEM, Collections.emptyList());
        CredentialsMatcher matcher = CredentialsMatchers.withId((String)credentialsId);
        StandardUsernamePasswordCredentials result = (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)matches, (CredentialsMatcher)matcher);
        return result;
    }

    public static String setCredentials(String hostName, String username, String password) {
        ArrayList<HostnameSpecification> domainSpecifications = new ArrayList<HostnameSpecification>();
        domainSpecifications.add(new HostnameSpecification(hostName, null));
        Domain domain = new Domain("Generated for " + hostName, "", domainSpecifications);
        SystemCredentialsProvider.getInstance().getDomainCredentialsMap().put(domain, new ArrayList());
        String credentialsId = UUID.randomUUID().toString();
        UsernamePasswordCredentialsImpl newCredential = new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, credentialsId, "Generated for " + username, username, password);
        ((List)SystemCredentialsProvider.getInstance().getDomainCredentialsMap().get(domain)).add(newCredential);
        try {
            SystemCredentialsProvider.getInstance().save();
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "SystemCredentialsProvider instance save failed: ", ex);
        }
        return credentialsId;
    }

    public static StandardUsernamePasswordCredentials findCredentialsForCollection(URI collectionUri) {
        TeamPluginGlobalConfig config = TeamPluginGlobalConfig.get();
        List<TeamCollectionConfiguration> pairs = config.getCollectionConfigurations();
        for (TeamCollectionConfiguration pair : pairs) {
            String candidateCollectionUrlString = pair.getCollectionUrl();
            URI candidateCollectionUri = URI.create(candidateCollectionUrlString);
            if (!TeamCollectionConfiguration.areSameCollectionUri(candidateCollectionUri, collectionUri)) continue;
            String credentialsId = pair.credentialsId;
            if (credentialsId != null) {
                return TeamCollectionConfiguration.findCredentialsById(credentialsId);
            }
            return null;
        }
        String template = "There is no team project collection configured for the URL '%1$s'.%nPlease go to Jenkins > Manage Jenkins > Configure System and then add a Team Project Collection with a Collection URL of '%1$s'.";
        String message = String.format("There is no team project collection configured for the URL '%1$s'.%nPlease go to Jenkins > Manage Jenkins > Configure System and then add a Team Project Collection with a Collection URL of '%1$s'.", collectionUri);
        throw new IllegalArgumentException(message);
    }

    public static TeamCollectionConfiguration findCollection(URI collectionUri) {
        TeamPluginGlobalConfig config = TeamPluginGlobalConfig.get();
        List<TeamCollectionConfiguration> pairs = config.getCollectionConfigurations();
        for (TeamCollectionConfiguration pair : pairs) {
            String candidateCollectionUrlString = pair.getCollectionUrl();
            URI candidateCollectionUri = URI.create(candidateCollectionUrlString);
            if (!TeamCollectionConfiguration.areSameCollectionUri(candidateCollectionUri, collectionUri)) continue;
            return pair;
        }
        return null;
    }

    public static List<TeamCollectionConfiguration> getConnectedCollections() {
        ArrayList<TeamCollectionConfiguration> connectedCollections = new ArrayList<TeamCollectionConfiguration>();
        TeamPluginGlobalConfig config = TeamPluginGlobalConfig.get();
        List<TeamCollectionConfiguration> collections = config.getCollectionConfigurations();
        for (TeamCollectionConfiguration c : collections) {
            if (!c.getConnectionParameters().isSendJobCompletionEvents() || !StringUtils.isNotEmpty((String)c.getConnectionParameters().getTeamCollectionUrl())) continue;
            connectedCollections.add(c);
        }
        return connectedCollections;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<TeamCollectionConfiguration> {
        public String getDisplayName() {
            return "Team Project Collection";
        }

        public FormValidation doCheckCollectionUrl(@QueryParameter String value) {
            URI uri;
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.warning((String)"Please provide a value");
            }
            try {
                uri = new URI(value);
            }
            catch (URISyntaxException e) {
                return FormValidation.error((String)"Malformed TFS/Team Services collection URL (%s)", (Object[])new Object[]{e.getMessage()});
            }
            String hostName = uri.getHost();
            if (StringUtils.isBlank((String)hostName)) {
                return FormValidation.error((String)"Please provide a host name");
            }
            if (TeamCollectionConfiguration.isTeamServices(hostName)) {
                return TeamCollectionConfiguration.checkTeamServices(uri);
            }
            return FormValidation.ok();
        }

        public FormValidation doTestCredentials(@QueryParameter String collectionUrl, @QueryParameter String credentialsId) {
            String errorTemplate = "Error: %s";
            String hostName = null;
            try {
                URI uri = new URI(collectionUrl);
                hostName = uri.getHost();
            }
            catch (URISyntaxException e) {
                return FormValidation.error((String)"Error: %s", (Object[])new Object[]{e.getMessage()});
            }
            try {
                StandardUsernamePasswordCredentials credential = TeamCollectionConfiguration.findCredentialsById(credentialsId);
                if (TeamCollectionConfiguration.isTeamServices(hostName) && credential == null) {
                    return FormValidation.error((String)"Error: %s", (Object[])new Object[]{"Team Services accounts need credentials, preferably a Personal Access Token"});
                }
                return TeamCollectionConfiguration.testConnection(collectionUrl, credential);
            }
            catch (IOException e) {
                return FormValidation.error((Throwable)e, (String)"Error: %s", (Object[])new Object[]{e.getMessage()});
            }
        }

        public ListBoxModel doFillCredentialsIdItems(@QueryParameter String collectionUrl) {
            Jenkins jenkins = Jenkins.getInstance();
            String hostName = null;
            try {
                URI uri = new URI(collectionUrl);
                hostName = uri.getHost();
            }
            catch (URISyntaxException uri) {
                // empty catch block
            }
            if (hostName == null || !jenkins.hasPermission(Jenkins.ADMINISTER)) {
                return new ListBoxModel();
            }
            List<StandardUsernamePasswordCredentials> matches = TeamCollectionConfiguration.findCredentials(hostName);
            return new StandardListBoxModel().withEmptySelection().withAll(matches);
        }
    }
}

