/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.tfs.TeamResultsAction;
import hudson.plugins.tfs.model.TeamRequestedResult;
import hudson.plugins.tfs.model.TeamResultType;
import hudson.plugins.tfs.telemetry.TelemetryHelper;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.DirScanner;
import hudson.util.FileVisitor;
import hudson.util.io.Archiver;
import hudson.util.io.ArchiverFactory;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class TeamCollectResultsPostBuildAction
extends Recorder
implements SimpleBuildStep {
    private static final String TEAM_RESULTS = "team-results";
    static final String TEAM_RESULTS_ZIP = "team-results.zip";
    private List<TeamRequestedResult> requestedResults = new ArrayList<TeamRequestedResult>();

    @DataBoundConstructor
    public TeamCollectResultsPostBuildAction() {
    }

    public List<TeamRequestedResult> getRequestedResults() {
        return this.requestedResults;
    }

    @DataBoundSetter
    public void setRequestedResults(List<TeamRequestedResult> requestedResults) {
        this.requestedResults = requestedResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        TelemetryHelper.sendEvent("team-collect-results", new TelemetryHelper.PropertyMapBuilder().build());
        PrintStream logger = listener.getLogger();
        logger.print("Recording results...");
        File rootDir = run.getRootDir();
        File resultsRoot = new File(rootDir, TEAM_RESULTS);
        for (TeamRequestedResult requestedResult : this.requestedResults) {
            TeamResultType teamResultType = requestedResult.getTeamResultType();
            String folderName = teamResultType.getFolderName();
            logger.print(" " + teamResultType.getDisplayName());
            File resultFolder = new File(resultsRoot, folderName);
            Files.createDirectories(resultFolder.toPath(), new FileAttribute[0]);
            String includes = requestedResult.getIncludes();
            FilePath resultPath = new FilePath(resultFolder);
            int numCopied = workspace.copyRecursiveTo(includes, resultPath);
            logger.print(" (" + numCopied + " file" + (numCopied == 1 ? "" : "s") + ")");
        }
        logger.print(". Compressing...");
        ArchiverFactory zip = ArchiverFactory.ZIP;
        File resultsZipFile = new File(rootDir, TEAM_RESULTS_ZIP);
        FileOutputStream outputStream = new FileOutputStream(resultsZipFile);
        try {
            Archiver archiver = zip.create((OutputStream)outputStream);
            try {
                DirScanner.Glob scanner = new DirScanner.Glob("team-results/**", null, false);
                scanner.scan(rootDir, (FileVisitor)archiver);
            }
            finally {
                IOUtils.closeQuietly((Closeable)archiver);
            }
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
        FileUtils.deleteDirectory((File)resultsRoot);
        TeamResultsAction.addToRun(run);
        logger.println(" Done.");
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Collect results for TFS/Team Services";
        }
    }
}

