/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs;

import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.Extension;
import hudson.model.BuildAuthorizationToken;
import hudson.model.BuildableItem;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.UnprotectedRootAction;
import hudson.plugins.tfs.model.AbstractCommand;
import hudson.plugins.tfs.model.BuildCommand;
import hudson.plugins.tfs.model.BuildWithParametersCommand;
import hudson.plugins.tfs.model.PingCommand;
import hudson.plugins.tfs.model.TeamBuildPayload;
import hudson.plugins.tfs.telemetry.TelemetryHelper;
import hudson.plugins.tfs.util.EndpointHelper;
import hudson.plugins.tfs.util.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.util.TimeDuration;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.kohsuke.stapler.ForwardToView;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Extension
public class TeamBuildEndpoint
implements UnprotectedRootAction {
    private static final Logger LOGGER = Logger.getLogger(TeamBuildEndpoint.class.getName());
    private static final Map<String, AbstractCommand.Factory> COMMAND_FACTORIES_BY_NAME;
    public static final String URL_NAME = "team-build";
    public static final String PARAMETER = "parameter";
    public static final String BUILD_SOURCE_BRANCH = "Build.SourceBranch";
    public static final String QUEUEJOBTASK_MULTIBRANCH_JOB_BRANCH = "QueueJobTask.MultibranchPipelineBranch";
    static final String URL_PREFIX = "/team-build/";
    private String commandName;
    private String jobName;

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return URL_NAME;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public String getJobName() {
        return this.jobName;
    }

    boolean decodeCommandAndJobNames(String pathInfo) {
        if (pathInfo.startsWith(URL_PREFIX)) {
            String restOfPath = pathInfo.substring(URL_PREFIX.length());
            int firstSlash = restOfPath.indexOf(47);
            if (firstSlash != -1) {
                this.commandName = restOfPath.substring(0, firstSlash);
                if (firstSlash < restOfPath.length() - 1) {
                    String encodedJobName = restOfPath.substring(firstSlash + 1);
                    try {
                        this.jobName = URLDecoder.decode(encodedJobName, MediaType.UTF_8.name());
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new Error(e);
                    }
                    return true;
                }
            } else {
                this.commandName = restOfPath;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse doIndex(HttpServletRequest request) throws IOException {
        Class<?> me = this.getClass();
        InputStream stream = me.getResourceAsStream("TeamBuildEndpoint.html");
        Jenkins instance = Jenkins.getActiveInstance();
        String rootUrl = instance.getRootUrl();
        String commandRows = TeamBuildEndpoint.describeCommands(COMMAND_FACTORIES_BY_NAME, URL_NAME);
        try {
            String template = IOUtils.toString((InputStream)stream, (Charset)MediaType.UTF_8);
            String content = String.format(template, URL_NAME, commandRows, rootUrl);
            HttpResponse httpResponse = HttpResponses.html((String)content);
            return httpResponse;
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    static String describeCommands(Map<String, AbstractCommand.Factory> commandMap, String urlName) {
        String newLine = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, AbstractCommand.Factory> commandPair : commandMap.entrySet()) {
            String commandName = commandPair.getKey();
            AbstractCommand.Factory factory = commandPair.getValue();
            sb.append("<tr>").append(newLine);
            sb.append("<td valign='top'>").append(commandName).append("</td>").append(newLine);
            sb.append("<td valign='top'>").append('/').append(urlName).append('/').append(commandName).append('/').append("JOB_NAME").append("</td>").append(newLine);
            String rawSample = factory.getSampleRequestPayload();
            String escapedSample = StringEscapeUtils.escapeHtml4((String)rawSample);
            sb.append("<td><pre>").append(escapedSample).append("</pre></td>").append(newLine);
            sb.append("</tr>").append(newLine);
        }
        return sb.toString();
    }

    void checkPermission(Job job, ParameterizedJobMixIn.ParameterizedJob jobMixin, StaplerRequest req, StaplerResponse rsp) throws IOException {
        BuildAuthorizationToken authToken = jobMixin.getAuthToken();
        BuildAuthorizationToken.checkPermission((Job)job, (BuildAuthorizationToken)authToken, (StaplerRequest)req, (StaplerResponse)rsp);
    }

    void dispatch(StaplerRequest req, StaplerResponse rsp, TimeDuration delay) throws IOException {
        try {
            JSONObject response = this.innerDispatch(req, rsp, delay);
            if (response.containsKey((Object)"created")) {
                rsp.setStatus(201);
            } else {
                rsp.setStatus(200);
            }
            rsp.setContentType("application/json; charset=utf-8");
            PrintWriter w = rsp.getWriter();
            String responseJsonString = response.toString();
            w.print(responseJsonString);
            w.println();
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.WARNING, "IllegalArgumentException", e);
            EndpointHelper.error(400, e);
        }
        catch (ForwardToView e) {
            throw e;
        }
        catch (Exception e) {
            String template = "Error while performing reaction to '%s' command.";
            String message = String.format("Error while performing reaction to '%s' command.", this.commandName);
            LOGGER.log(Level.SEVERE, message, e);
            EndpointHelper.error(500, e);
        }
    }

    private String getBranch(String jobName, StaplerRequest req) {
        String json = req.getParameter("json");
        JSONObject formData = JSONObject.fromObject((Object)json);
        TeamBuildPayload payload = (TeamBuildPayload)EndpointHelper.MAPPER.convertValue((Object)formData, TeamBuildPayload.class);
        String sourceBranch = payload.BuildVariables.get(QUEUEJOBTASK_MULTIBRANCH_JOB_BRANCH);
        if (sourceBranch == null || sourceBranch.trim().isEmpty()) {
            int idx = jobName.indexOf(47);
            sourceBranch = idx > 0 ? jobName.substring(idx + 1) : payload.BuildVariables.get(BUILD_SOURCE_BRANCH);
        }
        if (sourceBranch == null || sourceBranch.trim().isEmpty()) {
            throw new IllegalArgumentException("Could not find branch from job name.  If building a multibranchpipeline job, the job name should be in the format of '${multibranch pipeline name}/${branch}.'");
        }
        try {
            return URLEncoder.encode(sourceBranch.replace("refs/heads/", ""), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Failed to encode branch: " + sourceBranch, e);
        }
    }

    private String getJobNameFromNestedFolder(String jobName) {
        int idx = jobName.indexOf(47);
        if (idx > 0) {
            return jobName.substring(0, idx);
        }
        return jobName;
    }

    private Job getJob(String jobName, StaplerRequest req) {
        Jenkins jenkins = Jenkins.getActiveInstance();
        Job job = (Job)jenkins.getItemByFullName(jobName, Job.class);
        if (job == null) {
            Item item;
            Item mbPipelineJobItem = jenkins.getItemByFullName(jobName);
            Item item2 = item = mbPipelineJobItem != null ? mbPipelineJobItem : jenkins.getItemByFullName(this.getJobNameFromNestedFolder(jobName));
            if (item != null) {
                Collection allJobs = item.getAllJobs();
                String sourceBranch = this.getBranch(jobName, req);
                for (Job j : allJobs) {
                    if (!j.getName().equals(sourceBranch)) continue;
                    job = j;
                    break;
                }
            }
        }
        if (job == null) {
            throw new IllegalArgumentException("Job: " + jobName + " not found");
        }
        return job;
    }

    private JSONObject innerDispatch(StaplerRequest req, StaplerResponse rsp, TimeDuration delay) throws IOException, ServletException {
        this.commandName = null;
        this.jobName = null;
        String pathInfo = req.getPathInfo();
        if (!this.decodeCommandAndJobNames(pathInfo)) {
            if (this.commandName == null) {
                throw new IllegalArgumentException("Command not provided");
            }
            if (this.jobName == null) {
                throw new IllegalArgumentException("Job name not provided after command");
            }
        }
        if (!COMMAND_FACTORIES_BY_NAME.containsKey(this.commandName)) {
            throw new IllegalArgumentException("Command not implemented");
        }
        Job job = this.getJob(this.jobName, req);
        ParameterizedJobMixIn.ParameterizedJob jobMixin = (ParameterizedJobMixIn.ParameterizedJob)job;
        this.checkPermission(job, jobMixin, req, rsp);
        TimeDuration actualDelay = delay == null ? new TimeDuration((long)jobMixin.getQuietPeriod()) : delay;
        AbstractCommand.Factory factory = COMMAND_FACTORIES_BY_NAME.get(this.commandName);
        AbstractCommand command = factory.create();
        JSONObject formData = req.getSubmittedForm();
        ObjectMapper mapper = EndpointHelper.MAPPER;
        TeamBuildPayload teamBuildPayload = (TeamBuildPayload)mapper.convertValue((Object)formData, TeamBuildPayload.class);
        BuildableItem buildable = (BuildableItem)job;
        JSONObject response = command.perform(job, buildable, req, formData, mapper, teamBuildPayload, actualDelay);
        return response;
    }

    public void doPing(StaplerRequest request, StaplerResponse response, @QueryParameter TimeDuration delay) throws IOException {
        this.dispatch(request, response, delay);
    }

    public void doBuild(StaplerRequest request, StaplerResponse response, @QueryParameter TimeDuration delay) throws IOException {
        TelemetryHelper.sendEvent(URL_NAME, new TelemetryHelper.PropertyMapBuilder().build());
        this.dispatch(request, response, delay);
    }

    public void doBuildWithParameters(StaplerRequest request, StaplerResponse response, @QueryParameter TimeDuration delay) throws IOException {
        TelemetryHelper.sendEvent("team-build-parameters", new TelemetryHelper.PropertyMapBuilder().build());
        this.dispatch(request, response, delay);
    }

    static {
        TreeMap<String, AbstractCommand.Factory> map = new TreeMap<String, AbstractCommand.Factory>(String.CASE_INSENSITIVE_ORDER);
        map.put("ping", new PingCommand.Factory());
        map.put("build", new BuildCommand.Factory());
        map.put("buildWithParameters", new BuildWithParametersCommand.Factory());
        COMMAND_FACTORIES_BY_NAME = Collections.unmodifiableMap(map);
    }
}

