/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs;

import hudson.model.Action;
import hudson.plugins.tfs.util.QueryString;
import hudson.plugins.tfs.util.UriHelper;
import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=999)
public class TeamBuildDetailsAction
implements Action,
Serializable {
    private static final long serialVersionUID = 1L;
    public Map<String, String> buildVariables = new HashMap<String, String>();
    public String buildUrl;

    public TeamBuildDetailsAction() {
    }

    public TeamBuildDetailsAction(Map<String, String> buildVariables) {
        this.buildVariables = new HashMap<String, String>(buildVariables);
        this.buildUrl = TeamBuildDetailsAction.determineBuildUrl(buildVariables).toString();
    }

    static URI determineBuildUrl(Map<String, String> buildVariables) {
        String collectionUri = buildVariables.get("System.TeamFoundationCollectionUri");
        String projectName = buildVariables.get("System.TeamProject");
        String buildId = buildVariables.get("Build.BuildId");
        QueryString query = new QueryString("buildId", buildId);
        URI result = UriHelper.join(collectionUri, projectName, "_build", "index", query);
        return result;
    }

    public String getIconFileName() {
        return "/plugin/tfs/48x48/logo.png";
    }

    public String getDisplayName() {
        return "TFS/Team Services build";
    }

    public String getUrlName() {
        return "team-build";
    }

    @Exported
    public String getBuildNumber() {
        return this.buildVariables.get("Build.BuildNumber");
    }

    @Exported
    public String getBuildDefinitionName() {
        return this.buildVariables.get("Build.DefinitionName");
    }

    @Exported
    public String getBuildUrl() {
        return this.buildUrl;
    }
}

