/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.tfs.TeamFoundationServerScm;
import hudson.plugins.tfs.commands.LabelCommand;
import hudson.plugins.tfs.model.Server;
import hudson.plugins.tfs.telemetry.TelemetryHelper;
import hudson.plugins.tfs.util.BuildVariableResolver;
import hudson.scm.SCM;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

public class TFSLabeler
extends Notifier {
    private String whenToLabel;
    private String labelName;
    private static final Logger logger = Logger.getLogger(TFSLabeler.class.getName());

    @DataBoundConstructor
    public TFSLabeler(String whenToLabel, String labelName) {
        this.whenToLabel = whenToLabel;
        this.labelName = labelName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        SCM scm = build.getRootBuild().getProject().getScm();
        if (!(scm instanceof TeamFoundationServerScm)) {
            listener.getLogger().println("Labels are only supported for projects using the 'Team Foundation Server' SCM");
            return false;
        }
        TeamFoundationServerScm tfsScm = (TeamFoundationServerScm)scm;
        boolean buildSuccess = Result.SUCCESS.equals(build.getResult());
        String whenCreateLabel = this.getWhenToLabel();
        if ("always".equals(whenCreateLabel) || "success".equals(whenCreateLabel) && buildSuccess) {
            Launcher localLauncher = launcher != null ? launcher : new Launcher.LocalLauncher((TaskListener)listener);
            Server server = tfsScm.createServer(localLauncher, (TaskListener)listener, (Run<?, ?>)build.getRootBuild());
            Computer computer = Computer.currentComputer();
            String normalizedLabelName = this.computeDynamicValue(build, this.getLabelName());
            String tfsWorkspace = tfsScm.getWorkspaceName((Run<?, ?>)build.getRootBuild(), computer);
            String tfsProjectPath = this.computeDynamicValue(build, tfsScm.getProjectPath());
            try {
                logger.info(String.format("Create label '%s' on workspace '%s' with project path '%s' ", normalizedLabelName, tfsWorkspace, tfsProjectPath));
                LabelCommand labelCommand = new LabelCommand(server, normalizedLabelName, tfsWorkspace, tfsProjectPath);
                server.execute(labelCommand.getCallable());
                TelemetryHelper.sendEvent("team-label", new TelemetryHelper.PropertyMapBuilder().serverContext(server.getUrl(), server.getUrl()).build());
            }
            finally {
                server.close();
            }
        }
        return true;
    }

    private String computeDynamicValue(AbstractBuild build, String parameterizedValue) throws IllegalStateException, InterruptedException, IOException {
        final EnvVars envVars = build.getEnvironment(TaskListener.NULL);
        VariableResolver<String> environmentVariables = new VariableResolver<String>(){

            public String resolve(String name) {
                return (String)envVars.get((Object)name);
            }
        };
        BuildVariableResolver buildVariables = new BuildVariableResolver((Job<?, ?>)build.getProject());
        VariableResolver.Union bothVariables = new VariableResolver.Union(new VariableResolver[]{buildVariables, environmentVariables});
        String value = Util.replaceMacro((String)parameterizedValue, (VariableResolver)bothVariables);
        logger.fine("oldValue = " + parameterizedValue + "; newValue = " + value);
        return value;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.STEP;
    }

    public String getWhenToLabel() {
        return this.whenToLabel;
    }

    public String getLabelName() {
        return this.labelName;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(TFSLabeler.class);
        }

        public String getDisplayName() {
            return "Create a label in TFVC";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

