/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs;

import hudson.plugins.tfs.TeamCollectionConfiguration;
import hudson.plugins.tfs.model.ConnectionParameters;
import hudson.plugins.tfs.model.JobCompletionEventArgs;
import hudson.plugins.tfs.util.TeamRestClient;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Formatter;
import java.util.List;
import java.util.logging.Logger;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public final class JenkinsEventNotifier {
    private static final Logger log = Logger.getLogger(JenkinsEventNotifier.class.getName());
    private static final String ENCODING = "UTF-8";

    private JenkinsEventNotifier() {
    }

    public static void sendJobCompletionEvent(JSONObject payload) {
        List<TeamCollectionConfiguration> connectedCollections = TeamCollectionConfiguration.getConnectedCollections();
        for (TeamCollectionConfiguration c : connectedCollections) {
            try {
                ConnectionParameters connectionParameters = c.getConnectionParameters();
                TeamRestClient client = new TeamRestClient(URI.create(c.getCollectionUrl()));
                payload.put("server", (Object)connectionParameters.getConnectionKey());
                String jsonPayload = payload.toString();
                JobCompletionEventArgs args = new JobCompletionEventArgs(connectionParameters.getConnectionKey(), jsonPayload, JenkinsEventNotifier.getPayloadSignature(connectionParameters.getConnectionSignature(), jsonPayload));
                client.sendJobCompletionEvent(args);
            }
            catch (Exception e) {
                log.warning("ERROR: sendJobCompletionEvent: (collection=" + c.getCollectionUrl() + ") " + e.getMessage());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getApiJson(String url) {
        try {
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins == null) {
                return "";
            }
            String rootUrl = jenkins.getRootUrl();
            String fullUrl = JenkinsEventNotifier.urlCombine(rootUrl, url, "api", "json");
            CloseableHttpClient client = HttpClientBuilder.create().build();
            HttpGet request = new HttpGet(fullUrl);
            request.addHeader("User-Agent", "Jenkins-Self");
            HttpResponse response = client.execute((HttpUriRequest)request);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode > 202) {
                log.warning("ERROR: getApiJson: (url=" + url + ") failed due to Http error #" + statusCode);
                return null;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), ENCODING));){
                String line;
                StringBuilder result = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    result.append(line);
                    result.append("\n");
                }
                String string = result.toString();
                return string;
            }
        }
        catch (HttpHostConnectException e) {
            log.warning("ERROR: getApiJson: (url=" + url + ") " + e.getMessage());
            return null;
        }
        catch (Exception e) {
            log.warning("ERROR: getApiJson: (url=" + url + ") " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static String getPayloadSignature(String secret, String payload) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException {
        SecretKeySpec signingKey = new SecretKeySpec(secret.getBytes(ENCODING), "HmacSHA1");
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(signingKey);
        return JenkinsEventNotifier.toHexString(mac.doFinal(payload.getBytes(ENCODING)));
    }

    private static String urlCombine(String url, String ... parts) {
        StringBuilder sb = new StringBuilder();
        if (url != null) {
            sb.append(url);
            for (String s : parts) {
                if (!StringUtils.isNotBlank((String)s)) continue;
                if (sb.length() > 0 && sb.charAt(sb.length() - 1) != '/') {
                    sb.append("/");
                }
                sb.append(s);
            }
        }
        return sb.toString();
    }

    private static String toHexString(byte[] bytes) {
        Formatter formatter = new Formatter();
        for (byte b : bytes) {
            formatter.format("%02x", b);
        }
        return formatter.toString();
    }
}

