/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs;

import hudson.plugins.git.RevisionParameterAction;
import hudson.plugins.tfs.model.GitCodePushedEventArgs;
import hudson.plugins.tfs.util.UriHelper;
import java.net.URI;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;

public class CommitParameterAction
extends RevisionParameterAction {
    private final GitCodePushedEventArgs gitCodePushedEventArgs;

    public CommitParameterAction(GitCodePushedEventArgs e) {
        super(e.commit, e.getRepoURIish());
        this.gitCodePushedEventArgs = e;
    }

    public GitCodePushedEventArgs getGitCodePushedEventArgs() {
        return this.gitCodePushedEventArgs;
    }

    public boolean canOriginateFrom(Iterable<RemoteConfig> remotes) {
        URI repoUri = this.gitCodePushedEventArgs.repoUri;
        for (RemoteConfig remote : remotes) {
            for (URIish remoteURL : remote.getURIs()) {
                URI remoteUri = URI.create(remoteURL.toString());
                if (!UriHelper.areSameGitRepo(remoteUri, repoUri)) continue;
                return true;
            }
        }
        return false;
    }
}

