/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testlink.result;

import br.eti.kinoshita.testlinkjavaapi.constants.ExecutionStatus;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.plugins.testlink.TestLinkSite;
import hudson.plugins.testlink.result.AbstractTAPFileNameResultSeeker;
import hudson.plugins.testlink.result.ResultSeekerDescriptor;
import hudson.plugins.testlink.result.TestCaseWrapper;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;
import org.tap4j.model.TestResult;
import org.tap4j.model.TestSet;
import org.tap4j.util.StatusValues;

public class TAPFileNameMultiTestPointsResultSeeker
extends AbstractTAPFileNameResultSeeker {
    private static final long serialVersionUID = 3068999690225000000L;

    @DataBoundConstructor
    public TAPFileNameMultiTestPointsResultSeeker(String includePattern, String keyCustomField, boolean attachTAPStream, boolean attachYAMLishAttachments, boolean includeNotes, boolean compareFullPath, boolean testpointsAsExecutions) {
        super(includePattern, keyCustomField, attachTAPStream, attachYAMLishAttachments, includeNotes, compareFullPath);
    }

    @Override
    protected void updateTestCase(Map<String, TestSet> testSets, String key, TestCaseWrapper automatedTestCase, String value, AbstractBuild<?, ?> build, BuildListener listener, TestLinkSite testlink) {
        TestSet testSet = testSets.get(key);
        int executionNumbers = testSet.getNumberOfTestResults();
        Integer i = 1;
        while (i <= executionNumbers) {
            TestResult result = testSet.getTestResult(i);
            if (result != null) {
                ExecutionStatus status = result.getStatus().equals((Object)StatusValues.OK) ? ExecutionStatus.PASSED : ExecutionStatus.FAILED;
                automatedTestCase.addCustomFieldAndStatus(value, status);
                if (this.isIncludeNotes()) {
                    String notes = super.getTapNotes(testSets.get(key));
                    automatedTestCase.appendNotes(notes);
                }
                this.handleResult(automatedTestCase, build, listener, testlink, status, testSets, key);
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends ResultSeekerDescriptor {
        public String getDisplayName() {
            return "TAP file name (test points as TestLink executions)";
        }
    }
}

