/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testlink.result;

import br.eti.kinoshita.testlinkjavaapi.model.CustomField;
import hudson.DescriptorExtensionList;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.plugins.testlink.TestLinkSite;
import hudson.plugins.testlink.result.ResultSeekerDescriptor;
import hudson.plugins.testlink.result.ResultSeekerException;
import hudson.plugins.testlink.result.TestCaseWrapper;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;

public abstract class ResultSeeker
implements Serializable,
Describable<ResultSeeker>,
Comparable<ResultSeeker> {
    private static final long serialVersionUID = 3609106615463455486L;
    private static final Logger LOGGER = Logger.getLogger("hudson.plugins.testlink");
    protected final String includePattern;
    protected final String keyCustomField;
    protected final boolean includeNotes;

    public ResultSeeker(String includePattern, String keyCustomField, boolean includeNotes) {
        this.includePattern = includePattern;
        this.keyCustomField = keyCustomField;
        this.includeNotes = includeNotes;
    }

    public String getIncludePattern() {
        return this.includePattern;
    }

    public String getKeyCustomField() {
        return this.keyCustomField;
    }

    public boolean isIncludeNotes() {
        return this.includeNotes;
    }

    public ResultSeekerDescriptor getDescriptor() {
        return (ResultSeekerDescriptor)Hudson.getInstance().getDescriptor(this.getClass());
    }

    public static DescriptorExtensionList<ResultSeeker, Descriptor<ResultSeeker>> all() {
        return Hudson.getInstance().getDescriptorList(ResultSeeker.class);
    }

    public static DescriptorExtensionList<ResultSeeker, Descriptor<ResultSeeker>> allExcept(Node current) {
        return Hudson.getInstance().getDescriptorList(ResultSeeker.class);
    }

    public abstract void seek(TestCaseWrapper[] var1, AbstractBuild<?, ?> var2, Launcher var3, BuildListener var4, TestLinkSite var5) throws ResultSeekerException;

    protected String getBase64FileContent(File file) throws IOException {
        byte[] fileData = FileUtils.readFileToByteArray((File)file);
        return Base64.encodeBase64String((byte[])fileData);
    }

    protected String[] scan(File directory, String includes, BuildListener listener) throws IOException {
        String[] fileNames = new String[]{};
        if (StringUtils.isNotBlank((String)includes)) {
            FileSet fs = null;
            try {
                fs = Util.createFileSet((File)directory, (String)includes);
                DirectoryScanner ds = fs.getDirectoryScanner();
                fileNames = ds.getIncludedFiles();
            }
            catch (BuildException e) {
                e.printStackTrace(listener.getLogger());
                throw new IOException(e);
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            for (String fileName : fileNames) {
                LOGGER.log(Level.FINE, "Test result file found: " + fileName);
            }
        }
        return fileNames;
    }

    protected CustomField getKeyCustomField(List<CustomField> customFields, String keyCustomFieldName) {
        CustomField customField = null;
        for (CustomField cf : customFields) {
            boolean isKeyCustomField = cf.getName().equals(keyCustomFieldName);
            if (!isKeyCustomField) continue;
            customField = cf;
            break;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Key custom field used: " + customField);
        }
        return customField;
    }

    @Override
    public int compareTo(ResultSeeker o) {
        return o != null ? this.getDescriptor().getDisplayName().compareTo(o.getDescriptor().getDisplayName()) : 0;
    }
}

