/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testlink.result;

import br.eti.kinoshita.testlinkjavaapi.constants.ExecutionStatus;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.plugins.testlink.TestLinkSite;
import hudson.plugins.testlink.result.AbstractJUnitResultSeeker;
import hudson.plugins.testlink.result.ResultSeekerDescriptor;
import hudson.plugins.testlink.result.ResultSeekerException;
import hudson.plugins.testlink.result.TestCaseWrapper;
import hudson.plugins.testlink.util.Messages;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.JUnitParser;
import hudson.tasks.junit.SuiteResult;
import hudson.tasks.junit.TestResult;
import java.io.IOException;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

public class JUnitSuiteNameResultSeeker
extends AbstractJUnitResultSeeker {
    private static final long serialVersionUID = -969559401334833078L;

    @DataBoundConstructor
    public JUnitSuiteNameResultSeeker(String includePattern, String keyCustomField, boolean attachJUnitXML, boolean includeNotes) {
        super(includePattern, keyCustomField, attachJUnitXML, includeNotes);
    }

    @Override
    public void seek(TestCaseWrapper[] automatedTestCases, AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, TestLinkSite testlink) throws ResultSeekerException {
        listener.getLogger().println(Messages.Results_JUnit_LookingForTestSuites());
        try {
            JUnitParser parser = new JUnitParser(false);
            TestResult testResult = parser.parse(this.includePattern, build, launcher, (TaskListener)listener);
            for (SuiteResult suiteResult : testResult.getSuites()) {
                for (TestCaseWrapper automatedTestCase : automatedTestCases) {
                    String[] commaSeparatedValues;
                    for (String value : commaSeparatedValues = automatedTestCase.getKeyCustomFieldValues(this.keyCustomField)) {
                        if (!suiteResult.getName().equals(value)) continue;
                        ExecutionStatus status = this.getExecutionStatus(suiteResult);
                        automatedTestCase.addCustomFieldAndStatus(value, status);
                        if (this.isIncludeNotes()) {
                            String notes = this.getJUnitNotes(suiteResult);
                            automatedTestCase.appendNotes(notes);
                        }
                        super.handleResult(automatedTestCase, build, listener, testlink, suiteResult);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new ResultSeekerException(e);
        }
        catch (InterruptedException e) {
            throw new ResultSeekerException(e);
        }
    }

    private ExecutionStatus getExecutionStatus(SuiteResult suiteResult) {
        List cases = suiteResult.getCases();
        for (CaseResult caseResult : cases) {
            if (caseResult.isPassed() || caseResult.isSkipped()) continue;
            return ExecutionStatus.FAILED;
        }
        return ExecutionStatus.PASSED;
    }

    private String getJUnitNotes(SuiteResult testSuite) {
        StringBuilder notes = new StringBuilder();
        notes.append(Messages.Results_JUnit_NotesForTestSuite(testSuite.getName(), testSuite.getStderr(), testSuite.getStdout(), Integer.toString(testSuite.getCases().size()), Double.toString(testSuite.getDuration()), testSuite.getTimestamp()));
        return notes.toString();
    }

    @Extension
    public static class DescriptorImpl
    extends ResultSeekerDescriptor {
        public String getDisplayName() {
            return "JUnit suite name";
        }
    }
}

