/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testlink;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.plugins.testlink.AbstractTestLinkProjectAction;
import hudson.plugins.testlink.GraphHelper;
import hudson.plugins.testlink.Report;
import hudson.plugins.testlink.TestLinkBuildAction;
import hudson.plugins.testlink.TestLinkResult;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import hudson.util.Graph;
import java.io.IOException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.jfree.chart.JFreeChart;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class TestLinkProjectAction
extends AbstractTestLinkProjectAction {
    private static final int DEFAULT_GRAPH_WIDTH = 500;
    private static final int DEFAULT_GRAPH_HEIGHT = 200;
    private AbstractProject<?, ?> project;
    private transient Map<String, Integer> requestMap = new HashMap<String, Integer>();

    public TestLinkProjectAction(AbstractProject<?, ?> project) {
        this.project = project;
    }

    public AbstractProject<?, ?> getProject() {
        return this.project;
    }

    protected Class<TestLinkBuildAction> getBuildActionClass() {
        return TestLinkBuildAction.class;
    }

    public TestLinkBuildAction getLastBuildAction() {
        AbstractBuild<?, ?> lastBuild = this.getLastBuildWithTestLink();
        TestLinkBuildAction action = null;
        if (lastBuild != null) {
            action = (TestLinkBuildAction)lastBuild.getAction(this.getBuildActionClass());
        }
        return action;
    }

    private AbstractBuild<?, ?> getLastBuildWithTestLink() {
        AbstractBuild lastBuild;
        for (lastBuild = this.project.getLastBuild(); lastBuild != null && lastBuild.getAction(this.getBuildActionClass()) == null; lastBuild = lastBuild.getPreviousBuild()) {
        }
        return lastBuild;
    }

    public void doIndex(StaplerRequest req, StaplerResponse res) throws IOException {
        AbstractBuild<?, ?> lastBuild = this.getLastBuildWithTestLink();
        if (lastBuild == null) {
            res.sendRedirect2("nodata");
        } else {
            int buildNumber = lastBuild.getNumber();
            res.sendRedirect2(String.format("../%d/%s", buildNumber, "testLinkResult"));
        }
    }

    public void doGraph(final StaplerRequest req, StaplerResponse res) throws IOException {
        if (ChartUtil.awtProblemCause != null) {
            res.sendRedirect2(req.getContextPath() + "/images/headless.png");
            return;
        }
        if (this.newGraphNotNeeded(req, res)) {
            return;
        }
        final DataSetBuilder dataSetBuilder = new DataSetBuilder();
        this.populateDataSetBuilder((DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel>)dataSetBuilder);
        new Graph(-1L, this.getGraphWidth(), this.getGraphHeight()){

            protected JFreeChart createGraph() {
                return GraphHelper.createChart(req, dataSetBuilder.build());
            }
        }.doPng(req, res);
    }

    public void doGraphMap(final StaplerRequest req, StaplerResponse res) throws IOException {
        if (this.newGraphNotNeeded(req, res)) {
            return;
        }
        final DataSetBuilder dataSetBuilder = new DataSetBuilder();
        this.populateDataSetBuilder((DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel>)dataSetBuilder);
        new Graph(-1L, this.getGraphWidth(), this.getGraphHeight()){

            protected JFreeChart createGraph() {
                return GraphHelper.createChart(req, dataSetBuilder.build());
            }
        }.doMap(req, res);
    }

    public final boolean isDisplayGraph() {
        return this.project.getBuilds().size() > 0;
    }

    private boolean newGraphNotNeeded(StaplerRequest req, StaplerResponse res) {
        boolean newGraphNotNeeded = false;
        Calendar t = ((AbstractBuild)this.getProject().getLastCompletedBuild()).getTimestamp();
        Integer prevNumBuilds = this.requestMap.get(req.getRequestURI());
        int numBuilds = this.getProject().getBuilds().size();
        if ((prevNumBuilds = Integer.valueOf(prevNumBuilds == null ? 0 : prevNumBuilds)) != numBuilds) {
            this.requestMap.put(req.getRequestURI(), numBuilds);
        }
        if (this.requestMap.keySet().size() > 10) {
            this.requestMap.clear();
        }
        if (prevNumBuilds == numBuilds && req.checkIfModified(t, res)) {
            newGraphNotNeeded = true;
        }
        return newGraphNotNeeded;
    }

    protected void populateDataSetBuilder(DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel> dataset) {
        for (AbstractBuild build = this.getProject().getLastBuild(); build != null; build = build.getPreviousBuild()) {
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel((Run)build);
            TestLinkBuildAction action = (TestLinkBuildAction)build.getAction(this.getBuildActionClass());
            if (action == null) continue;
            TestLinkResult result = action.getResult();
            Report report = result.getReport();
            dataset.add((Number)report.getBlocked(), (Comparable)((Object)"Blocked"), (Comparable)label);
            dataset.add((Number)report.getFailed(), (Comparable)((Object)"Failed"), (Comparable)label);
            dataset.add((Number)report.getNotRun(), (Comparable)((Object)"Not Run"), (Comparable)label);
            dataset.add((Number)report.getPassed(), (Comparable)((Object)"Passed"), (Comparable)label);
        }
    }

    public int getGraphWidth() {
        return 500;
    }

    public int getGraphHeight() {
        return 200;
    }
}

