/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testlink;

import br.eti.kinoshita.testlinkjavaapi.TestLinkAPI;
import br.eti.kinoshita.testlinkjavaapi.constants.ExecutionStatus;
import br.eti.kinoshita.testlinkjavaapi.model.Build;
import br.eti.kinoshita.testlinkjavaapi.model.Platform;
import br.eti.kinoshita.testlinkjavaapi.model.TestCase;
import br.eti.kinoshita.testlinkjavaapi.model.TestPlan;
import br.eti.kinoshita.testlinkjavaapi.model.TestProject;
import br.eti.kinoshita.testlinkjavaapi.util.TestLinkAPIException;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.EnvironmentContributingAction;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.testlink.AbstractTestLinkBuilder;
import hudson.plugins.testlink.Report;
import hudson.plugins.testlink.TestLinkBuildAction;
import hudson.plugins.testlink.TestLinkBuilderDescriptor;
import hudson.plugins.testlink.TestLinkInstallation;
import hudson.plugins.testlink.TestLinkResult;
import hudson.plugins.testlink.TestLinkSite;
import hudson.plugins.testlink.result.ResultSeeker;
import hudson.plugins.testlink.result.ResultSeekerException;
import hudson.plugins.testlink.result.TestCaseWrapper;
import hudson.plugins.testlink.util.Messages;
import hudson.plugins.testlink.util.TestLinkHelper;
import hudson.tasks.BuildStep;
import hudson.tasks.Builder;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class TestLinkBuilder
extends AbstractTestLinkBuilder {
    private static final Logger LOGGER = Logger.getLogger("hudson.plugins.testlink");
    @Extension
    public static final TestLinkBuilderDescriptor DESCRIPTOR = new TestLinkBuilderDescriptor();

    public TestLinkBuilder(String testLinkName, String testProjectName, String testPlanName, String buildName, String customFields, Boolean executionStatusNotRun, Boolean executionStatusPassed, Boolean executionStatusFailed, Boolean executionStatusBlocked, List<BuildStep> singleBuildSteps, List<BuildStep> beforeIteratingAllTestCasesBuildSteps, List<BuildStep> iterativeBuildSteps, List<BuildStep> afterIteratingAllTestCasesBuildSteps, Boolean transactional, Boolean failedTestsMarkBuildAsFailure, Boolean failIfNoResults, List<ResultSeeker> resultSeekers) {
        this(testLinkName, testProjectName, testPlanName, buildName, null, customFields, executionStatusNotRun, executionStatusPassed, executionStatusFailed, executionStatusBlocked, singleBuildSteps, beforeIteratingAllTestCasesBuildSteps, iterativeBuildSteps, afterIteratingAllTestCasesBuildSteps, transactional, failedTestsMarkBuildAsFailure, failIfNoResults, false, resultSeekers);
    }

    public TestLinkBuilder(String testLinkName, String testProjectName, String testPlanName, String buildName, String customFields, Boolean executionStatusNotRun, Boolean executionStatusPassed, Boolean executionStatusFailed, Boolean executionStatusBlocked, List<BuildStep> singleBuildSteps, List<BuildStep> beforeIteratingAllTestCasesBuildSteps, List<BuildStep> iterativeBuildSteps, List<BuildStep> afterIteratingAllTestCasesBuildSteps, Boolean transactional, Boolean failedTestsMarkBuildAsFailure, Boolean failIfNoResults, Boolean failOnNotRun, List<ResultSeeker> resultSeekers) {
        super(testLinkName, testProjectName, testPlanName, buildName, null, customFields, executionStatusNotRun, executionStatusPassed, executionStatusFailed, executionStatusBlocked, singleBuildSteps, beforeIteratingAllTestCasesBuildSteps, iterativeBuildSteps, afterIteratingAllTestCasesBuildSteps, transactional, failedTestsMarkBuildAsFailure, failIfNoResults, failOnNotRun, resultSeekers);
    }

    public TestLinkBuilder(String testLinkName, String testProjectName, String testPlanName, String platformName, String buildName, String customFields, Boolean executionStatusNotRun, Boolean executionStatusPassed, Boolean executionStatusFailed, Boolean executionStatusBlocked, List<BuildStep> singleBuildSteps, List<BuildStep> beforeIteratingAllTestCasesBuildSteps, List<BuildStep> iterativeBuildSteps, List<BuildStep> afterIteratingAllTestCasesBuildSteps, Boolean transactional, Boolean failedTestsMarkBuildAsFailure, Boolean failIfNoResults, Boolean failOnNotRun, List<ResultSeeker> resultSeekers) {
        super(testLinkName, testProjectName, testPlanName, platformName, buildName, customFields, singleBuildSteps, beforeIteratingAllTestCasesBuildSteps, iterativeBuildSteps, afterIteratingAllTestCasesBuildSteps, transactional, failedTestsMarkBuildAsFailure, failIfNoResults, failOnNotRun, resultSeekers);
    }

    @DataBoundConstructor
    public TestLinkBuilder(String testLinkName, String testProjectName, String testPlanName, String platformName, String buildName, String customFields, String testPlanCustomFields, Boolean executionStatusNotRun, Boolean executionStatusPassed, Boolean executionStatusFailed, Boolean executionStatusBlocked, List<BuildStep> singleBuildSteps, List<BuildStep> beforeIteratingAllTestCasesBuildSteps, List<BuildStep> iterativeBuildSteps, List<BuildStep> afterIteratingAllTestCasesBuildSteps, Boolean transactional, Boolean failedTestsMarkBuildAsFailure, Boolean failIfNoResults, Boolean failOnNotRun, List<ResultSeeker> resultSeekers) {
        super(testLinkName, testProjectName, testPlanName, platformName, buildName, customFields, testPlanCustomFields, singleBuildSteps, beforeIteratingAllTestCasesBuildSteps, iterativeBuildSteps, afterIteratingAllTestCasesBuildSteps, transactional, failedTestsMarkBuildAsFailure, failIfNoResults, failOnNotRun, resultSeekers);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        TestCaseWrapper[] automatedTestCases;
        TestPlan testPlan;
        TestLinkSite testLinkSite;
        LOGGER.log(Level.INFO, "TestLink builder started");
        this.failure = false;
        listener.getLogger().println(Messages.TestLinkBuilder_PreparingTLAPI());
        TestLinkInstallation installation = DESCRIPTOR.getInstallationByTestLinkName(this.testLinkName);
        if (installation == null) {
            throw new AbortException(Messages.TestLinkBuilder_InvalidTLAPI());
        }
        TestLinkHelper.setTestLinkJavaAPIProperties(installation.getTestLinkJavaAPIProperties(), listener);
        String testLinkUrl = installation.getUrl();
        String testLinkDevKey = installation.getDevKey();
        listener.getLogger().println(Messages.TestLinkBuilder_UsedTLURL(testLinkUrl));
        try {
            String testProjectName = TestLinkHelper.expandVariable((VariableResolver<String>)build.getBuildVariableResolver(), build.getEnvironment((TaskListener)listener), this.getTestProjectName());
            String testPlanName = TestLinkHelper.expandVariable((VariableResolver<String>)build.getBuildVariableResolver(), build.getEnvironment((TaskListener)listener), this.getTestPlanName());
            String platformName = TestLinkHelper.expandVariable((VariableResolver<String>)build.getBuildVariableResolver(), build.getEnvironment((TaskListener)listener), this.getPlatformName());
            String buildName = TestLinkHelper.expandVariable((VariableResolver<String>)build.getBuildVariableResolver(), build.getEnvironment((TaskListener)listener), this.getBuildName());
            String buildNotes = Messages.TestLinkBuilder_Build_Notes();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "TestLink project name: [" + testProjectName + "]");
                LOGGER.log(Level.FINE, "TestLink plan name: [" + testPlanName + "]");
                LOGGER.log(Level.FINE, "TestLink platform name: [" + platformName + "]");
                LOGGER.log(Level.FINE, "TestLink build name: [" + buildName + "]");
                LOGGER.log(Level.FINE, "TestLink build notes: [" + buildNotes + "]");
            }
            testLinkSite = this.getTestLinkSite(testLinkUrl, testLinkDevKey, testProjectName, testPlanName, platformName, buildName, buildNotes);
            if (StringUtils.isNotBlank((CharSequence)platformName) && testLinkSite.getPlatform() == null) {
                listener.getLogger().println(Messages.TestLinkBuilder_PlatformNotFound(platformName));
            }
            String[] testCaseCustomFieldsNames = TestLinkHelper.createArrayOfCustomFieldsNames((VariableResolver<String>)build.getBuildVariableResolver(), build.getEnvironment((TaskListener)listener), this.getCustomFields());
            TestCase[] testCases = testLinkSite.getAutomatedTestCases(testCaseCustomFieldsNames);
            String[] testPlanCustomFieldsNames = TestLinkHelper.createArrayOfCustomFieldsNames((VariableResolver<String>)build.getBuildVariableResolver(), build.getEnvironment((TaskListener)listener), this.getTestPlanCustomFields());
            testPlan = testLinkSite.getTestPlanWithCustomFields(testPlanCustomFieldsNames);
            automatedTestCases = this.transform(testCases);
            testCases = null;
            listener.getLogger().println(Messages.TestLinkBuilder_ShowFoundAutomatedTestCases(automatedTestCases.length));
            listener.getLogger().println(Messages.TestLinkBuilder_SortingTestCases());
            Arrays.sort(automatedTestCases, this.executionOrderComparator);
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace(listener.fatalError(mue.getMessage()));
            throw new AbortException(Messages.TestLinkBuilder_InvalidTLURL(testLinkUrl));
        }
        catch (TestLinkAPIException e) {
            e.printStackTrace(listener.fatalError(e.getMessage()));
            throw new AbortException(Messages.TestLinkBuilder_TestLinkCommunicationError());
        }
        for (TestCaseWrapper tcw : automatedTestCases) {
            testLinkSite.getReport().addTestCase(tcw);
            if (!LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.log(Level.FINE, "TestLink automated test case ID [" + tcw.getId() + "], name [" + tcw.getName() + "]");
        }
        listener.getLogger().println(Messages.TestLinkBuilder_ExecutingSingleBuildSteps());
        this.executeSingleBuildSteps(automatedTestCases.length, testPlan, testLinkSite, build, launcher, listener);
        listener.getLogger().println(Messages.TestLinkBuilder_ExecutingIterativeBuildSteps());
        this.executeIterativeBuildSteps(automatedTestCases, testPlan, testLinkSite, build, launcher, listener);
        try {
            listener.getLogger().println(Messages.Results_LookingForTestResults());
            if (this.getResultSeekers() != null) {
                for (ResultSeeker resultSeeker : this.getResultSeekers()) {
                    LOGGER.log(Level.INFO, "Seeking test results. Using: " + resultSeeker.getDescriptor().getDisplayName());
                    resultSeeker.seek(automatedTestCases, build, launcher, listener, testLinkSite);
                }
            }
        }
        catch (ResultSeekerException trse) {
            trse.printStackTrace(listener.fatalError(trse.getMessage()));
            throw new AbortException(Messages.Results_ErrorToLookForTestResults(trse.getMessage()));
        }
        catch (TestLinkAPIException tlae) {
            tlae.printStackTrace(listener.fatalError(tlae.getMessage()));
            throw new AbortException(Messages.TestLinkBuilder_FailedToUpdateTL(tlae.getMessage()));
        }
        Report report = testLinkSite.getReport();
        report.tally();
        listener.getLogger().println(Messages.TestLinkBuilder_ShowFoundTestResults(report.getTestsTotal()));
        TestLinkResult result = new TestLinkResult(report);
        TestLinkBuildAction buildAction = new TestLinkBuildAction(result);
        build.addAction((Action)buildAction);
        if (report.getTestsTotal() <= 0 && this.getFailIfNoResults() == Boolean.TRUE) {
            listener.getLogger().println("No test results found. Setting the build result as FAILURE.");
            build.setResult(Result.FAILURE);
        } else if (report.getFailed() > 0) {
            if (this.failedTestsMarkBuildAsFailure != null && this.failedTestsMarkBuildAsFailure.booleanValue()) {
                listener.getLogger().println("There are failed tests, setting the build result as FAILURE.");
                build.setResult(Result.FAILURE);
            } else {
                listener.getLogger().println("There are failed tests, setting the build result as UNSTABLE.");
                build.setResult(Result.UNSTABLE);
            }
        } else if (this.getFailOnNotRun() != null && this.getFailOnNotRun().booleanValue() && report.getNotRun() > 0) {
            listener.getLogger().println("There are not run tests, setting the build result as FAILURE.");
            build.setResult(Result.FAILURE);
        }
        LOGGER.log(Level.INFO, "TestLink builder finished");
        return Boolean.TRUE;
    }

    private TestCaseWrapper[] transform(TestCase[] testCases) {
        if (testCases == null || testCases.length == 0) {
            return new TestCaseWrapper[0];
        }
        ArrayList<TestCaseWrapper> automatedTestCases = new ArrayList<TestCaseWrapper>();
        for (TestCase testCase : testCases) {
            TestCaseWrapper wrapper = new TestCaseWrapper(testCase);
            automatedTestCases.add(wrapper);
        }
        return automatedTestCases.toArray(new TestCaseWrapper[0]);
    }

    public TestLinkSite getTestLinkSite(String testLinkUrl, String testLinkDevKey, String testProjectName, String testPlanName, String platformName, String buildName, String buildNotes) throws MalformedURLException {
        URL url = new URL(testLinkUrl);
        TestLinkAPI api = new TestLinkAPI(url, testLinkDevKey);
        TestProject testProject = api.getTestProjectByName(testProjectName);
        TestPlan testPlan = api.getTestPlanByName(testPlanName, testProjectName);
        Platform platform = null;
        if (StringUtils.isNotBlank((CharSequence)platformName)) {
            Platform[] platforms;
            for (Platform p : platforms = api.getProjectPlatforms(testProject.getId())) {
                if (!p.getName().equals(platformName)) continue;
                platform = p;
                break;
            }
        }
        Build build = api.createBuild(testPlan.getId(), buildName, buildNotes);
        return new TestLinkSite(api, testProject, testPlan, platform, build);
    }

    protected void executeSingleBuildSteps(int numberOfTests, TestPlan testPlan, TestLinkSite testLinkSite, AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        if (this.singleBuildSteps != null) {
            for (BuildStep b : this.singleBuildSteps) {
                final EnvVars iterativeEnvVars = TestLinkHelper.buildTestCaseEnvVars(numberOfTests, testLinkSite.getTestProject(), testPlan, testLinkSite.getBuild(), listener);
                build.addAction((Action)new EnvironmentContributingAction(){

                    public void buildEnvVars(AbstractBuild<?, ?> build, EnvVars env) {
                        env.putAll((Map)iterativeEnvVars);
                    }

                    public String getUrlName() {
                        return null;
                    }

                    public String getIconFileName() {
                        return null;
                    }

                    public String getDisplayName() {
                        return null;
                    }
                });
                boolean success = b.perform(build, launcher, listener);
                if (success) continue;
                this.failure = Boolean.TRUE;
            }
        }
    }

    protected void executeIterativeBuildSteps(TestCaseWrapper[] automatedTestCases, TestPlan testPlan, TestLinkSite testLinkSite, AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        int success;
        if (this.beforeIteratingAllTestCasesBuildSteps != null) {
            for (BuildStep b : this.beforeIteratingAllTestCasesBuildSteps) {
                success = b.perform(build, launcher, listener) ? 1 : 0;
                if (success != 0) continue;
                this.failure = Boolean.TRUE;
            }
        }
        for (TestCaseWrapper automatedTestCase : automatedTestCases) {
            if (this.failure && this.transactional.booleanValue()) {
                automatedTestCase.setExecutionStatus(ExecutionStatus.BLOCKED);
                continue;
            }
            if (this.iterativeBuildSteps == null) continue;
            final EnvVars iterativeEnvVars = TestLinkHelper.buildTestCaseEnvVars(automatedTestCase, testLinkSite.getTestProject(), testPlan, testLinkSite.getBuild(), listener);
            build.addAction((Action)new EnvironmentContributingAction(){

                public void buildEnvVars(AbstractBuild<?, ?> build, EnvVars env) {
                    env.putAll((Map)iterativeEnvVars);
                }

                public String getUrlName() {
                    return null;
                }

                public String getIconFileName() {
                    return null;
                }

                public String getDisplayName() {
                    return null;
                }
            });
            for (BuildStep b : this.iterativeBuildSteps) {
                boolean success2 = b.perform(build, launcher, listener);
                if (success2) continue;
                this.failure = Boolean.TRUE;
            }
        }
        if (this.afterIteratingAllTestCasesBuildSteps != null) {
            for (BuildStep b : this.afterIteratingAllTestCasesBuildSteps) {
                success = b.perform(build, launcher, listener) ? 1 : 0;
                if (success != 0) continue;
                this.failure = Boolean.TRUE;
            }
        }
    }

    public Descriptor<Builder> getDescriptor() {
        return (TestLinkBuilderDescriptor)super.getDescriptor();
    }
}

