/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testlink;

import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.plugins.testlink.Report;
import hudson.plugins.testlink.TestLinkResult;
import hudson.plugins.testlink.util.TestLinkHelper;
import java.io.Serializable;
import jenkins.model.RunAction2;
import org.kohsuke.stapler.StaplerProxy;

public class TestLinkBuildAction
implements RunAction2,
Serializable,
StaplerProxy {
    private static final long serialVersionUID = -914904584770393909L;
    public static final String DISPLAY_NAME = "TestLink";
    public static final String ICON_FILE_NAME = "/plugin/testlink/icons/testlink-24.png";
    public static final String URL_NAME = "testLinkResult";
    private transient Run<?, ?> build;
    private TestLinkResult result;

    public TestLinkBuildAction(TestLinkResult result) {
        this.result = result;
    }

    @Deprecated
    public TestLinkBuildAction(AbstractBuild<?, ?> build, TestLinkResult result) {
        this.build = build;
        this.result = result;
    }

    public void onLoad(Run<?, ?> r) {
        this.build = r;
    }

    public void onAttached(Run<?, ?> r) {
        this.build = r;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getIconFileName() {
        return ICON_FILE_NAME;
    }

    public String getUrlName() {
        return URL_NAME;
    }

    public Object getTarget() {
        return this.result;
    }

    public Run<?, ?> getRun() {
        return this.build;
    }

    public AbstractBuild<?, ?> getBuild() {
        if (this.build instanceof AbstractBuild) {
            return (AbstractBuild)this.build;
        }
        throw new IllegalStateException("Calling old API against a non-AbstractBuild run type. Run: " + this.build);
    }

    public TestLinkResult getResult() {
        return this.result;
    }

    private Report getPreviousReport() {
        TestLinkResult previousResult = this.getPreviousResult();
        Report previousReport = null;
        if (previousResult != null) {
            previousReport = previousResult.getReport();
        }
        return previousReport;
    }

    public TestLinkResult getPreviousResult() {
        TestLinkBuildAction previousAction = this.getPreviousAction();
        TestLinkResult previousResult = null;
        if (previousAction != null) {
            previousResult = previousAction.getResult();
        }
        return previousResult;
    }

    public TestLinkBuildAction getPreviousAction() {
        Run previousBuild;
        if (this.build != null && (previousBuild = this.build.getPreviousBuild()) != null) {
            return (TestLinkBuildAction)previousBuild.getAction(TestLinkBuildAction.class);
        }
        return null;
    }

    public String getSummary() {
        return TestLinkHelper.createReportSummary(this.result.getReport(), this.getPreviousReport());
    }

    public String getDetails() {
        return TestLinkHelper.createReportSummaryDetails(this.result.getReport(), this.getPreviousReport());
    }
}

