/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testlink;

import hudson.plugins.testlink.result.TestCaseWrapper;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

public class Report
implements Serializable {
    private static final long serialVersionUID = 3686192971774873173L;
    private int passed = 0;
    private int failed = 0;
    private int blocked = 0;
    private int notRun = 0;
    private final int buildId;
    private final String buildName;
    private final List<TestCaseWrapper> testCases;

    Report(int buildId, String buildName) {
        this.buildId = buildId;
        this.buildName = buildName;
        this.testCases = new LinkedList<TestCaseWrapper>();
    }

    public int getTestsTotal() {
        return this.passed + this.failed + this.blocked + this.notRun;
    }

    public int getPassed() {
        return this.passed;
    }

    public void setPassed(int passed) {
        this.passed = passed;
    }

    public int getFailed() {
        return this.failed;
    }

    public void setFailed(int failed) {
        this.failed = failed;
    }

    public int getBlocked() {
        return this.blocked;
    }

    public void setBlocked(int blocked) {
        this.blocked = blocked;
    }

    public int getNotRun() {
        return this.notRun;
    }

    public void setNotRun(int notRun) {
        this.notRun = notRun;
    }

    public int getBuildId() {
        return this.buildId;
    }

    public String getBuildName() {
        return this.buildName;
    }

    public void addTestCase(TestCaseWrapper testCase) {
        this.testCases.add(testCase);
    }

    public List<TestCaseWrapper> getTestCases() {
        return this.testCases;
    }

    public void tally() {
        this.blocked = 0;
        this.failed = 0;
        this.notRun = 0;
        this.passed = 0;
        for (TestCaseWrapper tcw : this.getTestCases()) {
            switch (tcw.getExecutionStatus()) {
                case BLOCKED: {
                    ++this.blocked;
                    break;
                }
                case FAILED: {
                    ++this.failed;
                    break;
                }
                case NOT_RUN: {
                    ++this.notRun;
                    break;
                }
                case PASSED: {
                    ++this.passed;
                    break;
                }
            }
        }
    }
}

