/*
 * Decompiled with CFR 0.152.
 */
package com.jenkins.testresultsaggregator.reporter;

import com.jenkins.testresultsaggregator.data.Aggregated;
import com.jenkins.testresultsaggregator.data.Data;
import com.jenkins.testresultsaggregator.data.Job;
import com.jenkins.testresultsaggregator.data.JobStatus;
import com.jenkins.testresultsaggregator.helper.LocalMessages;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URL;

public class XMLReporter {
    public static final String REPORT_XML_FILE = "aggregated.xml";
    private PrintStream logger;
    private File workspace;
    public static final String S = "<";
    public static final String SE = "</";
    public static final String E = ">";
    public static final String TAB = "\t";
    public static final String ROOT = "AGGREGATED";
    public static final String RESULTS = "RESULTS";
    public static final String JOBS = "JOBS";
    public static final String JOB = "JOB";
    public static final String NAME = "NAME";
    public static final String STATUS = "STATUS";
    public static final String URL = "URL";

    public XMLReporter(PrintStream logger, File rootDir) {
        this.logger = logger;
        this.workspace = rootDir;
    }

    public void generateXMLReport(Aggregated aggregated) {
        try {
            this.logger.print(LocalMessages.GENERATE.toString() + " " + LocalMessages.XML_REPORT.toString());
            String fileName = this.workspace.getAbsolutePath() + System.getProperty("file.separator") + REPORT_XML_FILE;
            PrintWriter writer = new PrintWriter(fileName, "UTF-8");
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.println("<AGGREGATED>");
            writer.println("\t<RESULTS>");
            writer.println("\t\t" + this.xmlTag("SUCCESS", aggregated.getSuccessJobs()));
            writer.println("\t\t" + this.xmlTag("FIXED", aggregated.getFixedJobs()));
            writer.println("\t\t" + this.xmlTag("ABORTED", aggregated.getAbortedJobs()));
            writer.println("\t\t" + this.xmlTag("FAILED", aggregated.getFailedJobs()));
            writer.println("\t\t" + this.xmlTag("KEEPFAILLING", aggregated.getKeepFailJobs()));
            writer.println("\t\t" + this.xmlTag("RUNNING", aggregated.getRunningJobs()));
            writer.println("\t\t" + this.xmlTag("UNSTABLE", aggregated.getUnstableJobs()));
            writer.println("\t\t" + this.xmlTag("KEEPUNSTABLE", aggregated.getKeepUnstableJobs()));
            writer.println("\t\t" + this.xmlTag("TEST_TOTAL", aggregated.getResults().getTotal()));
            writer.println("\t\t" + this.xmlTag("TEST_SUCCESS", aggregated.getResults().getPass()));
            writer.println("\t\t" + this.xmlTag("TEST_FAILED", aggregated.getResults().getFail()));
            writer.println("\t\t" + this.xmlTag("TEST_SKIPPED", aggregated.getResults().getSkip()));
            writer.println("\t</RESULTS>");
            writer.println("\t<JOBS>");
            for (Data data : aggregated.getData()) {
                for (Job dataJob : data.getJobs()) {
                    if (dataJob.getBuildInfo() == null) continue;
                    writer.println("\t\t<JOB>");
                    writer.println("\t\t\t" + this.xmlTag(NAME, dataJob.getJobName()));
                    if (dataJob.getResults() != null) {
                        writer.println("\t\t\t" + this.xmlTag(STATUS, dataJob.getResults().getStatus()));
                        if (JobStatus.DISABLED.name().equalsIgnoreCase(dataJob.getResults().getCurrentResult())) {
                            this.jobStatus(writer, dataJob, dataJob.getJobInfo().getUrl(), true);
                        } else if (JobStatus.NOT_FOUND.name().equalsIgnoreCase(dataJob.getResults().getCurrentResult())) {
                            this.jobStatus(writer, dataJob, null, false);
                        } else {
                            this.jobStatus(writer, dataJob, dataJob.getJobInfo().getLastBuild().getUrl(), true);
                        }
                    } else {
                        this.jobStatus(writer, dataJob, dataJob.getJobInfo().getLastBuild().getUrl(), true);
                    }
                    writer.println("\t\t</JOB>");
                }
            }
            writer.println("\t</JOBS>");
            writer.println("</AGGREGATED>");
            writer.close();
            this.logger.println(LocalMessages.FINISHED.toString() + " " + LocalMessages.XML_REPORT.toString());
        }
        catch (IOException e) {
            this.logger.println("");
            this.logger.printf(LocalMessages.ERROR_OCCURRED.toString() + ": " + e.getMessage(), new Object[0]);
            e.printStackTrace();
        }
    }

    private String xmlTag(String tag, Object content) {
        if (content != null) {
            return S + tag + E + content + SE + tag + E;
        }
        return S + tag + "></" + tag + E;
    }

    private void jobStatus(PrintWriter writer, Job dataJob, URL url, boolean found) {
        writer.println("\t\t\t" + this.xmlTag(URL, url));
        if (found) {
            writer.println("\t\t\t" + this.xmlTag("TEST_TOTAL", dataJob.getResults().getTotal()));
            writer.println("\t\t\t" + this.xmlTag("TEST_SUCCESS", dataJob.getResults().getPass()));
            writer.println("\t\t\t" + this.xmlTag("TEST_SKIPPED", dataJob.getResults().getSkip()));
            writer.println("\t\t\t" + this.xmlTag("TEST_FAILED", dataJob.getResults().getFail()));
            writer.println("\t\t\t" + this.xmlTag("CC_PACKAGES", dataJob.getResults().getCcPackages()));
            writer.println("\t\t\t" + this.xmlTag("CC_FILES", dataJob.getResults().getCcFiles()));
            writer.println("\t\t\t" + this.xmlTag("CC_CLASSES", dataJob.getResults().getCcClasses()));
            writer.println("\t\t\t" + this.xmlTag("CC_METHODS", dataJob.getResults().getCcMethods()));
            writer.println("\t\t\t" + this.xmlTag("CC_LINES", dataJob.getResults().getCcLines()));
            writer.println("\t\t\t" + this.xmlTag("CC_CONDITIONALS", dataJob.getResults().getCcConditions()));
        } else {
            writer.println("\t\t\t" + this.xmlTag("TEST_TOTAL", 0));
            writer.println("\t\t\t" + this.xmlTag("TEST_SUCCESS", 0));
            writer.println("\t\t\t" + this.xmlTag("TEST_SKIPPED", 0));
            writer.println("\t\t\t" + this.xmlTag("TEST_FAILED", 0));
            writer.println("\t\t\t" + this.xmlTag("CC_PACKAGES", 0));
            writer.println("\t\t\t" + this.xmlTag("CC_FILES", 0));
            writer.println("\t\t\t" + this.xmlTag("CC_CLASSES", 0));
            writer.println("\t\t\t" + this.xmlTag("CC_METHODS", 0));
            writer.println("\t\t\t" + this.xmlTag("CC_LINES", 0));
            writer.println("\t\t\t" + this.xmlTag("CC_CONDITIONALS", 0));
        }
    }
}

