/*
 * Decompiled with CFR 0.152.
 */
package com.jenkins.testresultsaggregator.reporter;

import com.google.common.base.Strings;
import com.jenkins.testresultsaggregator.TestResultsAggregator;
import com.jenkins.testresultsaggregator.data.Aggregated;
import com.jenkins.testresultsaggregator.data.Data;
import com.jenkins.testresultsaggregator.data.ImagesMap;
import com.jenkins.testresultsaggregator.data.Job;
import com.jenkins.testresultsaggregator.data.JobStatus;
import com.jenkins.testresultsaggregator.helper.LocalMessages;
import com.jenkins.testresultsaggregator.reporter.HTMLReporter;
import com.jenkins.testresultsaggregator.reporter.MailNotification;
import com.jenkins.testresultsaggregator.reporter.XMLReporter;
import hudson.FilePath;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class Reporter {
    private PrintStream logger;
    private FilePath workspace;
    private File rootDir;
    private String mailNotificationFrom;
    private boolean ignoreNotFoundJobs;
    private boolean ignoreDisabledJobs;
    private boolean ignoreAbortedJobs;
    private boolean foundAtLeastOneGroupName;

    public Reporter(PrintStream logger, FilePath workspace, File rootDir, String mailNotificationFrom, Boolean ignoreDisabledJobs, Boolean ignoreNotFoundJobs, Boolean ignoreAbortedJobs) {
        this.logger = logger;
        this.workspace = workspace;
        this.rootDir = rootDir;
        this.mailNotificationFrom = mailNotificationFrom;
        this.ignoreDisabledJobs = ignoreDisabledJobs;
        this.ignoreNotFoundJobs = ignoreNotFoundJobs;
        this.ignoreAbortedJobs = ignoreAbortedJobs;
    }

    public void publishResuts(Aggregated aggregated, Properties properties, List<LocalMessages> columns, File rootDirectory) throws Exception {
        List<Data> dataJob = aggregated.getData();
        this.foundAtLeastOneGroupName = false;
        for (Data data : dataJob) {
            if (Strings.isNullOrEmpty((String)data.getGroupName())) continue;
            this.foundAtLeastOneGroupName = true;
            break;
        }
        new XMLReporter(this.logger, this.rootDir).generateXMLReport(aggregated);
        if (!this.foundAtLeastOneGroupName) {
            columns.remove((Object)LocalMessages.COLUMN_GROUP);
        }
        Aggregated aggregatedCopy = aggregated.copy();
        if (this.ignoreDisabledJobs) {
            this.ignoreJobsFromReport(aggregatedCopy.getData(), JobStatus.DISABLED);
        }
        if (this.ignoreNotFoundJobs) {
            this.ignoreJobsFromReport(aggregatedCopy.getData(), JobStatus.NOT_FOUND);
        }
        if (this.ignoreAbortedJobs) {
            this.ignoreJobsFromReport(aggregatedCopy.getData(), JobStatus.ABORTED);
        }
        FilePath htmlReport = new HTMLReporter(this.logger, this.workspace).createOverview(aggregatedCopy, columns, properties.getProperty(TestResultsAggregator.AggregatorProperties.THEME.name()), this.foundAtLeastOneGroupName);
        String bodyText = this.generateMailBody(htmlReport.read());
        Map<String, ImagesMap.ImageData> images = this.resolveImages(bodyText);
        new MailNotification(this.logger, aggregatedCopy.getData(), this.workspace, rootDirectory).send(properties.getProperty(TestResultsAggregator.AggregatorProperties.RECIPIENTS_LIST.name()), this.mailNotificationFrom, this.generateMailSubject(properties.getProperty(TestResultsAggregator.AggregatorProperties.SUBJECT_PREFIX.name()), aggregatedCopy), bodyText, images, properties.getProperty(TestResultsAggregator.AggregatorProperties.TEXT_BEFORE_MAIL_BODY.name()), properties.getProperty(TestResultsAggregator.AggregatorProperties.TEXT_AFTER_MAIL_BODY.name()));
    }

    private void ignoreJobsFromReport(List<Data> list, JobStatus status) {
        for (Data tempData : list) {
            ArrayList<Job> tempList = new ArrayList<Job>();
            for (Job temp : tempData.getJobs()) {
                if (temp.getResults() == null || status.name().equalsIgnoreCase(temp.getResults().getStatus())) continue;
                tempList.add(temp);
            }
            tempData.setJobs(tempList);
        }
    }

    private String generateMailBody(InputStream inputStream) throws Exception {
        BufferedReader buf = new BufferedReader(new InputStreamReader(inputStream, Charset.forName("UTF-8")));
        String line = buf.readLine();
        StringBuilder sb = new StringBuilder();
        while (line != null) {
            sb.append(line).append("\n");
            line = buf.readLine();
        }
        buf.close();
        String body = sb.toString();
        Set<String> setImageID = ImagesMap.getImages().keySet();
        for (String contentId : setImageID) {
            body = body.replaceAll(ImagesMap.getImages().get(contentId).getFileName(), ImagesMap.getImages().get(contentId).getCid());
        }
        return body;
    }

    private Map<String, ImagesMap.ImageData> resolveImages(String bodyText) {
        HashMap<String, ImagesMap.ImageData> images = new HashMap<String, ImagesMap.ImageData>();
        Set<String> setImageID = ImagesMap.getImages().keySet();
        for (String contentId : setImageID) {
            if (!bodyText.contains(ImagesMap.getImages().get(contentId).getCid())) continue;
            images.put(contentId, ImagesMap.getImages().get(contentId));
        }
        return images;
    }

    private String generateMailSubject(String subjectPrefix, Aggregated aggregated) {
        String subject = subjectPrefix;
        if (aggregated.getRunningJobs() > 0) {
            subject = subject + " " + LocalMessages.RESULTS_RUNNING.toString() + " : " + aggregated.getRunningJobs();
        }
        if (aggregated.getSuccessJobs() > 0 || aggregated.getFixedJobs() > 0) {
            subject = subject + " " + LocalMessages.RESULTS_SUCCESS.toString() + " : " + (aggregated.getSuccessJobs() + aggregated.getFixedJobs());
        }
        if (aggregated.getFailedJobs() > 0 || aggregated.getKeepFailJobs() > 0) {
            subject = subject + " " + LocalMessages.RESULTS_FAILED.toString() + " : " + (aggregated.getFailedJobs() + aggregated.getKeepFailJobs());
        }
        if (aggregated.getUnstableJobs() > 0 || aggregated.getKeepUnstableJobs() > 0) {
            subject = subject + " " + LocalMessages.RESULTS_UNSTABLE.toString() + " : " + (aggregated.getUnstableJobs() + aggregated.getKeepUnstableJobs());
        }
        if (aggregated.getAbortedJobs() > 0) {
            subject = subject + " " + LocalMessages.RESULTS_ABORTED.toString() + " : " + aggregated.getAbortedJobs();
        }
        return subject;
    }
}

