/*
 * Decompiled with CFR 0.152.
 */
package com.jenkins.testresultsaggregator.reporter;

import com.google.common.base.Strings;
import com.jenkins.testresultsaggregator.data.Data;
import com.jenkins.testresultsaggregator.data.ImagesMap;
import com.jenkins.testresultsaggregator.data.Job;
import com.jenkins.testresultsaggregator.data.JobStatus;
import com.jenkins.testresultsaggregator.helper.Helper;
import com.jenkins.testresultsaggregator.helper.LocalMessages;
import com.jenkins.testresultsaggregator.reporter.HTMLReporter;
import hudson.FilePath;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import jenkins.plugins.mailer.tasks.MimeMessageBuilder;

public class MailNotification {
    private PrintStream logger;
    private List<Data> dataJob;
    private FilePath workspace;
    private File rootDirectory;
    private boolean useImages = true;

    public MailNotification(PrintStream logger, List<Data> dataJob, FilePath workspace, File rootDirectory) {
        this.logger = logger;
        this.dataJob = dataJob;
        this.workspace = workspace;
        this.rootDirectory = rootDirectory;
    }

    private boolean validateResults() {
        boolean allJobsNotFound = true;
        block0: for (Data tempDataDTO : this.dataJob) {
            for (Job tempDataJobDTO : tempDataDTO.getJobs()) {
                if (tempDataJobDTO.getBuildInfo() == null || JobStatus.NOT_FOUND.name().equals(tempDataJobDTO.getBuildInfo().getResult())) continue;
                allJobsNotFound = false;
                continue block0;
            }
        }
        return allJobsNotFound;
    }

    public void send(String mailTo, String mailFrom, String subject, String body, Map<String, ImagesMap.ImageData> images, String preBodyText, String afterBodyText) throws Exception {
        this.logger.print(LocalMessages.GENERATE.toString() + " " + LocalMessages.EMAIL_REPORT.toString());
        MimeMessageBuilder mimeMessageBuilder = new MimeMessageBuilder();
        MimeMessage message = null;
        if (this.validateResults()) {
            this.logger.println(LocalMessages.VALIDATION_MAIL_NOT_FOUND_JOBS.toString());
        } else if (Strings.isNullOrEmpty((String)mailTo)) {
            this.logger.println(LocalMessages.VALIDATION_MAIL_RECEIPIENTS_EMPTY.toString());
        } else {
            try {
                String[] to;
                for (String recipient : to = mailTo.split(",")) {
                    mimeMessageBuilder.addRecipients(recipient);
                }
                StringBuffer messageBody = new StringBuffer();
                if (!Strings.isNullOrEmpty((String)preBodyText)) {
                    preBodyText = this.resolveVariables(preBodyText);
                    messageBody.append(preBodyText);
                    messageBody.append("<br></br>");
                }
                messageBody.append(body);
                if (!Strings.isNullOrEmpty((String)afterBodyText)) {
                    afterBodyText = this.resolveVariables(afterBodyText);
                    messageBody.append("<br></br>");
                    messageBody.append(afterBodyText);
                }
                mimeMessageBuilder.setBody(messageBody.toString());
                mimeMessageBuilder.setSubject(subject);
                mimeMessageBuilder.setMimeType("text/html");
                message = mimeMessageBuilder.buildMimeMessage();
                message.setFrom((Address)new InternetAddress(mailFrom));
                this.useImages(messageBody, images, message);
                message.saveChanges();
                this.sendMessage(message);
                this.logger.println(LocalMessages.SEND_MAIL_TO.toString());
                this.logger.println("" + mailTo);
            }
            catch (Exception ex) {
                this.logger.printf(LocalMessages.ERROR_OCCURRED.toString() + ": " + ex.getMessage(), new Object[0]);
                this.logger.println(LocalMessages.SEND_MAIL_TO.toString());
                if (message != null) {
                    message = mimeMessageBuilder.buildMimeMessage();
                    message.setFrom((Address)new InternetAddress(mailFrom));
                    message.saveChanges();
                    this.sendMessage(message);
                }
                ex.printStackTrace();
                this.logger.println("");
            }
        }
    }

    private void sendMessage(MimeMessage message) throws Exception {
        Transport.send((Message)message);
    }

    private void useImages(StringBuffer messageBody, Map<String, ImagesMap.ImageData> images, MimeMessage message) throws MessagingException, IOException, InterruptedException, URISyntaxException {
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setContent((Object)messageBody.toString(), "text/html");
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)messageBodyPart);
        if (this.useImages && images != null && !images.isEmpty()) {
            Set<String> setImageID = images.keySet();
            for (String contentId : setImageID) {
                multipart.addBodyPart((BodyPart)this.addImagePart(contentId));
            }
            message.setContent((Multipart)multipart);
        }
    }

    private MimeBodyPart addImagePart(String contentId) throws MessagingException, IOException, InterruptedException, URISyntaxException {
        ImagesMap.ImageData imageData = ImagesMap.getImages().get(contentId);
        MimeBodyPart imagePart = new MimeBodyPart();
        imagePart.setHeader("Content-ID", "<" + contentId + ">");
        imagePart.setDisposition("inline");
        FilePath localFile = Helper.createFile(this.workspace, imageData.getSourcePath());
        File copied = new File(this.rootDirectory + "/" + imageData.getFileName());
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(localFile.getRemote()));
             BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(copied));){
            int lengthRead;
            byte[] buffer = new byte[1024];
            while ((lengthRead = ((InputStream)in).read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, lengthRead);
                ((OutputStream)out).flush();
            }
        }
        imagePart.attachFile(copied);
        return imagePart;
    }

    protected File copyStream(String sourceFile, String destinationFile, File directory) throws IOException, InterruptedException {
        InputStream inputUrl = HTMLReporter.class.getResource(sourceFile).openStream();
        Helper.createFile(new FilePath(directory), destinationFile).copyFrom(inputUrl);
        return new File(directory + destinationFile);
    }

    private String resolveVariables(String text) {
        return text != null ? text.trim() : "";
    }
}

